# 画面設計書 89-アップグレードステータス（非推奨）

## 概要

本ドキュメントは、OpenSearchのインデックスアップグレードステータス（Get Upgrade）REST APIエンドポイントの画面設計書である。本APIは非推奨であり、将来のバージョンで削除される予定である。

### 本画面の処理概要

アップグレードステータスAPIは、インデックスのアップグレード状態を取得するためのAPIであった。各インデックスのセグメントがどの程度最新のLuceneフォーマットにアップグレードされているかの情報を返す。

**業務上の目的・背景**：アップグレードAPI（No.88）によるインデックスアップグレードの進捗を確認するために使用されていた。古いLuceneバージョンで作成されたセグメントがどの程度残っているかを把握し、アップグレードの必要性を判断する目的があった。しかし、アップグレードAPI自体が非推奨となったため、本APIも同様に非推奨である。REST API仕様においても「The _upgrade API is no longer useful and will be removed」と明記されている。

**画面へのアクセス方法**：HTTPクライアントから `GET /{index}/_upgrade` または `GET /_upgrade` エンドポイントへリクエストを送信する。

**主要な操作・処理内容**：
1. 全インデックスまたは特定インデックスのアップグレードステータスを取得する

**画面遷移**：アップグレード（No.88）の実行前後にステータスを確認するために使用される。

**権限による表示制御**：インデックスの監視権限が必要である。権限がない場合は403エラーが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | インデックス作成 | 主機能 | インデックスアップグレードステータス取得処理（非推奨API） |

## 画面種別

情報取得（APIエンドポイント）-- 非推奨

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_upgrade` | 全インデックスのアップグレードステータスを取得 |
| GET | `/{index}/_upgrade` | 指定インデックスのアップグレードステータスを取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| index | list | 任意 | カンマ区切りのインデックス名。`_all`または空文字で全インデックス対象 |

### クエリパラメータ

| パラメータ名 | 型 | デフォルト | 説明 |
|-------------|------|-----------|------|
| ignore_unavailable | boolean | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | open | ワイルドカード展開の対象（open/closed/hidden/none/all） |

## 表示項目

### レスポンス

| フィールド | 型 | 説明 |
|-----------|------|------|
| _shards.total | integer | 対象の総シャード数 |
| _shards.successful | integer | 成功のシャード数 |
| _shards.failed | integer | 失敗のシャード数 |
| {index_name}.size_in_bytes | long | インデックスサイズ（バイト） |
| {index_name}.size_to_upgrade_in_bytes | long | アップグレードが必要なサイズ（バイト） |
| {index_name}.size_to_upgrade_ancient_in_bytes | long | 古いLuceneバージョンのセグメントサイズ（バイト） |

## イベント仕様

### 1-アップグレードステータス取得

クライアントがGETリクエストを送信すると、`RestUpgradeAction`内のGetUpgradeステータス処理が実行される。REST API仕様ファイル`indices.get_upgrade.json`で定義されたGETメソッドにより、インデックスの各シャードからアップグレード状態が収集される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| アップグレードステータス取得 | - | SELECT | 読み取り専用。データ更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 発生条件 |
|-------------|------|-----------|---------|
| - | 成功 | `{"_shards":{...},"{index}":{...}}` | アップグレードステータス正常取得 |
| - | 警告 | 非推奨API使用の警告 | 本APIは非推奨のため |
| - | エラー | `{"error":{"type":"index_not_found_exception",...}}` | 指定インデックスが存在しない |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|--------------|------|
| IndexNotFoundException | 404 | 指定したインデックスが存在しない場合 |

## 備考

- 本APIは非推奨であり、将来のバージョンで削除される予定である。
- REST API仕様に「The _upgrade API is no longer useful and will be removed」と明記されている。
- GETメソッドでアクセスし、アップグレードが必要なセグメントのサイズ情報を返す。
- アップグレードAPI（No.88）と同一の`RestUpgradeAction`クラスで処理される可能性がある。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | indices.get_upgrade.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_upgrade.json` | REST APIの仕様定義。GETメソッドでのアクセスとパラメータを把握 |

**読解のコツ**: `indices.upgrade.json`（POST）と`indices.get_upgrade.json`（GET）は異なるAPI仕様ファイルだが、同一のエンドポイントパス`/_upgrade`を共有している点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestUpgradeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpgradeAction.java` | RESTハンドラ。POSTメソッドのみ定義されているため、GETのルーティングは別途確認が必要 |

**主要処理フロー**:
1. **59行目**: `routes()`で`POST /_upgrade`と`POST /{index}/_upgrade`を登録（GETはRestUpgradeStatusAction等の別ハンドラの可能性がある）

### プログラム呼び出し階層図

```
GET /_upgrade リクエスト
    |
    +-- (GETハンドラ) [アップグレードステータス取得]
            |
            +-- UpgradeStatusRequest [構築]
            |       +-- IndicesOptions.fromRequest()
            |
            +-- TransportUpgradeStatusAction.execute()
                    +-- 各シャードからアップグレード状態を収集
```

### データフロー図

```
[入力]                       [処理]                          [出力]

HTTP GET /{index}/_upgrade   GETハンドラ                     UpgradeStatusResponse
  +-- index (path)      ---> UpgradeStatusRequest [構築] ---> {_shards: {...},
                              TransportUpgradeStatusAction     "{index}": {
                              各シャードの状態収集               size_in_bytes,
                                                               size_to_upgrade_in_bytes}}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| indices.get_upgrade.json | `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_upgrade.json` | API仕様 | REST APIの仕様定義（非推奨） |
| RestUpgradeAction.java | `server/src/main/java/org/opensearch/rest/action/admin/indices/RestUpgradeAction.java` | ソース | RESTハンドラ（POST用、GETとは別の可能性あり） |
