# 画面設計書 91-クラスタ状態

## 概要

本ドキュメントは、OpenSearchのCluster State API（`GET /_cluster/state`）の画面設計書である。クラスタの包括的な状態情報を取得するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタの包括的な状態情報（メタデータ、ルーティングテーブル、ノード情報、ブロック情報など）をJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：クラスタの運用管理において、クラスタの全体的な状態を把握することは不可欠である。本APIは、クラスタマネージャノードが管理するクラスタ状態のスナップショットを提供し、インデックスのメタデータ、シャードのルーティング情報、ノードの参加状況、ブロック状態などの詳細情報を一括取得できる。運用監視ツールやトラブルシューティング時に頻繁に利用される。

**画面へのアクセス方法**：HTTPクライアント（curl、OpenSearch Dashboards Dev Tools等）から `GET /_cluster/state` にリクエストを送信する。メトリクスやインデックスでフィルタリングも可能。

**主要な操作・処理内容**：
1. クラスタ状態の全情報取得（`GET /_cluster/state`）
2. 指定メトリクスのみの取得（`GET /_cluster/state/{metric}`）
3. 指定メトリクスかつ指定インデックスの状態取得（`GET /_cluster/state/{metric}/{index}`）

**画面遷移**：本APIで取得した情報を基に、クラスタヘルス（No.90）、クラスタ統計（No.92）、クラスタ設定取得（No.93）、アロケーション説明（No.95）、クラスタ再ルーティング（No.96）へと関連する操作を行うことが多い。

**権限による表示制御**：クラスタ状態の取得にはクラスタレベルの読み取り権限が必要である。Security Pluginが有効な場合、適切なパーミッションが設定されていないとアクセスが拒否される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | クラスタ状態管理 | 主機能 | クラスタの包括的な状態情報（メタデータ・ルーティング等）を返す処理 |

## 画面種別

詳細（REST API レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cluster/state` | クラスタ状態の全情報を取得 |
| GET | `/_cluster/state/{metric}` | 指定メトリクスのクラスタ状態を取得 |
| GET | `/_cluster/state/{metric}/{index}` | 指定メトリクス・インデックスのクラスタ状態を取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 | 選択肢 |
|-------------|------|------|------|--------|
| metric | list | いいえ | 取得する情報を制限するメトリクス | `_all`, `blocks`, `metadata`, `nodes`, `routing_table`, `routing_nodes`, `master_node`, `cluster_manager_node`, `version` |
| index | list | いいえ | 対象インデックス（カンマ区切り、`_all`で全インデックス） | - |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| local | boolean | いいえ | false | ローカルノードの情報を返す（クラスタマネージャノードから取得しない） |
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）クラスタマネージャノードへの接続タイムアウト。`cluster_manager_timeout`を使用すること |
| flat_settings | boolean | いいえ | false | 設定をフラット形式で返す |
| wait_for_metadata_version | number | いいえ | - | 指定したメタデータバージョン以上になるまで待機 |
| wait_for_timeout | time | いいえ | - | wait_for_metadata_version待機時の最大タイムアウト |
| ignore_unavailable | boolean | いいえ | false | 利用不可のインデックスを無視するか |
| allow_no_indices | boolean | いいえ | true | ワイルドカードが具体的なインデックスに解決されない場合に無視するか |
| expand_wildcards | enum | いいえ | open | ワイルドカードの展開対象（`open`, `closed`, `hidden`, `none`, `all`） |

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| cluster_name | string | クラスタ名 |
| cluster_uuid | string | クラスタの一意識別子 |
| version | number | クラスタ状態のバージョン番号 |
| state_uuid | string | クラスタ状態のUUID |
| master_node | string | 現在のクラスタマネージャノードID |
| blocks | object | インデックス・クラスタレベルのブロック情報 |
| nodes | object | クラスタに参加しているノード情報 |
| metadata | object | インデックスのメタデータ（マッピング、設定、エイリアス等） |
| routing_table | object | シャードのルーティングテーブル |
| routing_nodes | object | ノード別のシャード割り当て情報 |
| wait_for_timed_out | boolean | wait_for_metadata_version指定時のタイムアウト有無 |

## イベント仕様

### 1-クラスタ状態取得

クライアントからGETリクエストを受信すると、以下の処理が実行される。

1. `RestClusterStateAction.prepareRequest()` でリクエストパラメータを解析し `ClusterStateRequest` を構築
2. `metric` パラメータが指定されている場合、`ClusterState.Metric.parseString()` でメトリクスを解析し、必要な情報のみをリクエストに設定
3. `local=true` の場合はローカルノードの状態を返却、それ以外はクラスタマネージャノードから状態を取得
4. `wait_for_metadata_version` が指定されている場合、指定バージョン以上になるまでブロッキング待機
5. レスポンスとして `ClusterStateResponse` を構築し、`ClusterState.toXContent()` でJSON形式にシリアライズして返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラスタ状態取得 | - | SELECT（読み取りのみ） | クラスタ状態はインメモリの `ClusterState` オブジェクトから読み取り。永続化ストアへの書き込みなし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データの更新は発生しない。クラスタ状態はクラスタマネージャノードが管理するインメモリ状態から取得される。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + クラスタ状態JSON | 正常にクラスタ状態を取得できた場合 |
| - | 警告（非推奨） | "Assigning [master_node] to parameter [metric] is deprecated..." | metricパラメータに `master_node` を指定した場合 |
| - | エラー | 408 Request Timeout | wait_for_metadata_version 指定時にタイムアウトした場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| タイムアウト | 408 | `wait_for_metadata_version` 指定時に `wait_for_timeout` 以内に条件が満たされなかった場合 |
| クラスタマネージャ不在 | 503 | クラスタマネージャノードに接続できない場合 |
| 権限不足 | 403 | Security Plugin有効時に適切な権限がない場合 |

## 備考

- `master_node` メトリクスは非推奨であり、バージョン3.0で削除予定。代わりに `cluster_manager_node` を使用すること。
- `master_timeout` パラメータも非推奨であり、`cluster_manager_timeout` を使用すること。
- 本APIは CircuitBreaker をトリップしない（`canTripCircuitBreaker()` が `false`）。
- `routing_table` と `routing_nodes` は内部的に同じ情報セットである（Java API上は単一のフラグで制御）。
- システムインデックスへのアクセスがデフォルトで許可されている（`allowSystemIndexAccessByDefault()` が `true`）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クラスタ状態のリクエスト・レスポンスに使用されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateRequest.java` | リクエストオブジェクトのフィールド構成（nodes, routingTable, metadata, blocks, customs, waitForMetadataVersion等） |
| 1-2 | ClusterStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateResponse.java` | レスポンスオブジェクトの構成（ClusterState, clusterName, waitForTimedOut） |
| 1-3 | ClusterState.java | `server/src/main/java/org/opensearch/cluster/ClusterState.java` | クラスタ状態のコアデータ構造。Metricの列挙型定義を含む |

**読解のコツ**: `ClusterState.Metric` 列挙型が、metricパラメータの選択肢と内部処理の対応を定義している。

#### Step 2: エントリーポイントを理解する

REST APIハンドラがリクエストを受け取り、トランスポートアクションに委譲する流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterStateAction.java` | RESTリクエストの受付とパラメータ解析 |

**主要処理フロー**:
1. **行92-99**: `routes()` でGETエンドポイント3パターンを登録
2. **行108-171**: `prepareRequest()` でリクエストパラメータを解析し `ClusterStateRequest` を構築
3. **行127-151**: metricパラメータの解析。`ClusterState.Metric.parseString()` でメトリクスのEnumSetを取得し、各フラグを設定
4. **行154-170**: クラスタクライアント経由で状態取得し、`RestBuilderListener` でレスポンスを構築

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClusterStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/TransportClusterStateAction.java` | クラスタマネージャノードでのクラスタ状態取得処理 |

### プログラム呼び出し階層図

```
RestClusterStateAction.prepareRequest() [行108]
    |
    +-- ClusterStateRequest の構築 [行109-151]
    |       +-- IndicesOptions.fromRequest() [行110]
    |       +-- ClusterState.Metric.parseString() [行128]
    |
    +-- NodeClient.admin().cluster().state() [行154]
            |
            +-- TransportClusterStateAction.clusterManagerOperation()
                    |
                    +-- ClusterState の取得・フィルタリング
                    |
                    +-- ClusterStateResponse の構築
                            |
                            +-- RestBuilderListener.buildResponse() [行156]
                                    +-- ClusterState.toXContent() [行166]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

GET /_cluster/state      --> RestClusterStateAction          --> ClusterStateResponse
  ?metric=...                  |                                    |
  ?local=...                   +-- ClusterStateRequest構築          +-- cluster_name
  ?flat_settings=...           +-- TransportAction実行              +-- version
  ?wait_for_metadata_version   +-- ClusterState取得                 +-- state_uuid
                               +-- メトリクスフィルタリング          +-- nodes
                                                                    +-- metadata
                                                                    +-- routing_table
                                                                    +-- blocks
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterStateAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterStateAction.java` | ソース | RESTハンドラ。リクエスト解析とレスポンス構築 |
| ClusterStateRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateRequest.java` | ソース | リクエストデータモデル |
| ClusterStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateResponse.java` | ソース | レスポンスデータモデル |
| TransportClusterStateAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/TransportClusterStateAction.java` | ソース | トランスポートアクション（クラスタマネージャでの実行） |
| ClusterState.java | `server/src/main/java/org/opensearch/cluster/ClusterState.java` | ソース | クラスタ状態のコアデータ構造 |
| cluster.state.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.state.json` | 設定 | REST API仕様定義 |
