# 画面設計書 92-クラスタ統計

## 概要

本ドキュメントは、OpenSearchのCluster Stats API（`GET /_cluster/stats`）の画面設計書である。クラスタ統計の概要を取得するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、OpenSearchクラスタの統計情報（ノード数、インデックス数、ドキュメント数、ストアサイズ、JVM統計、OS統計など）をJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：クラスタ全体のリソース使用状況やパフォーマンス指標を一括で把握するために利用される。容量計画、パフォーマンス監視、クラスタの健全性評価において重要な情報を提供する。Prometheus等の監視ツールと連携して定期的にメトリクスを収集する用途にも使用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cluster/stats` にリクエストを送信する。特定ノードに限定した統計を取得する場合は `GET /_cluster/stats/nodes/{node_id}` を使用する。

**主要な操作・処理内容**：
1. クラスタ全体の統計取得（`GET /_cluster/stats`）
2. 特定ノードの統計取得（`GET /_cluster/stats/nodes/{nodeId}`）
3. メトリクス指定での統計取得（`GET /_cluster/stats/{metric}/nodes/{nodeId}`）
4. メトリクスおよびインデックスメトリクス指定での統計取得（`GET /_cluster/stats/{metric}/{index_metric}/nodes/{nodeId}`）

**画面遷移**：クラスタヘルス（No.90）で問題を検知した際に本APIで詳細統計を確認し、必要に応じてノード情報（No.107）やノード統計（No.108）で個別ノードの調査を行う。

**権限による表示制御**：クラスタ統計の取得にはクラスタレベルのモニタリング権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | クラスタ統計 | 主機能 | クラスタ統計の概要を返す処理 |

## 画面種別

詳細（REST API レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cluster/stats` | クラスタ全体の統計を取得 |
| GET | `/_cluster/stats/nodes/{nodeId}` | 特定ノードの統計を取得 |
| GET | `/_cluster/stats/{metric}/nodes/{nodeId}` | メトリクス指定でノード統計を取得 |
| GET | `/_cluster/stats/{metric}/{index_metric}/nodes/{nodeId}` | メトリクス・インデックスメトリクス指定で統計を取得 |

## 入出力項目

### パスパラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|------|------|------|
| nodeId | list | いいえ | ノードIDまたはノード名のカンマ区切りリスト。`_local` で接続先ノードのみ |
| metric | string | いいえ | 取得するメトリクス（`_all` で全メトリクス） |
| index_metric | string | いいえ | 取得するインデックスメトリクス（`_all` で全インデックスメトリクス） |

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | いいえ | false | 設定をフラット形式で返す |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| _nodes | object | ノードの成功・失敗統計 |
| cluster_name | string | クラスタ名 |
| cluster_uuid | string | クラスタのUUID |
| timestamp | number | 統計取得時のタイムスタンプ |
| status | string | クラスタヘルスステータス（green/yellow/red） |
| indices | object | インデックス統計（ドキュメント数、ストアサイズ、シャード数等） |
| nodes | object | ノード統計（JVM、OS、プロセス、ファイルシステム等） |

## イベント仕様

### 1-クラスタ統計取得

クライアントからGETリクエストを受信すると、以下の処理が実行される。

1. `RestClusterStatsAction.prepareRequest()` でリクエストパラメータを解析
2. `fromRequest()` メソッドで `ClusterStatsRequest` を構築
3. メトリクスパラメータを検証し、無効なメトリクスが含まれる場合は `IllegalArgumentException` をスロー
4. `_all` と個別メトリクスが同時に指定された場合はエラー
5. インデックスメトリクスが指定されているがインデックス統計が要求されていない場合はエラー
6. 各ノードに統計収集リクエストを分散送信し、集約された結果を返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラスタ統計取得 | - | SELECT（読み取りのみ） | 各ノードの統計情報をインメモリから収集。永続化ストアへの書き込みなし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + クラスタ統計JSON | 正常に統計を取得できた場合 |
| - | エラー | 400 Bad Request | 無効なメトリクスが指定された場合 |
| - | エラー | 400 Bad Request "contains _all and individual metrics" | `_all` と個別メトリクスが同時指定された場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| IllegalArgumentException | 400 | 無効なメトリクス名が指定された場合 |
| IllegalArgumentException | 400 | `_all` と個別メトリクスの同時指定 |
| IllegalArgumentException | 400 | インデックスメトリクス指定時にインデックス統計が要求されていない場合 |
| タイムアウト | 408 | ノードからの応答がタイムアウトした場合 |

## 備考

- 本APIは CircuitBreaker をトリップしない（`canTripCircuitBreaker()` が `false`）。
- `useAggregatedNodeLevelResponses(true)` が設定され、集約済みノードレベルレスポンスが使用される。
- `computeAllMetrics(false)` により、リクエストされたメトリクスのみが計算される。
- メトリクスフィルタリングにより、必要な統計のみを取得してパフォーマンスを最適化可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsRequest.java` | リクエストのMetric・IndexMetric列挙型、メトリクスフィルタリングの仕組み |
| 1-2 | ClusterStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsResponse.java` | レスポンスの構成（indices, nodes等） |

**読解のコツ**: `Metric` と `IndexMetric` の列挙型が、利用可能なメトリクスの全リストを定義している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterStatsAction.java` | RESTハンドラ。メトリクスの解析とバリデーション |

**主要処理フロー**:
1. **行67-76**: `routes()` で4パターンのGETエンドポイントを登録
2. **行104-107**: `prepareRequest()` で `fromRequest()` を呼び出しリクエストを構築
3. **行109-148**: `fromRequest()` でメトリクス/インデックスメトリクスの解析・バリデーション・設定
4. **行150-183**: `paramValidations()` で `_all` と個別メトリクスの同時指定チェック

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClusterStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/TransportClusterStatsAction.java` | 各ノードへの統計収集リクエスト分散と集約処理 |

### プログラム呼び出し階層図

```
RestClusterStatsAction.prepareRequest() [行104]
    |
    +-- fromRequest() [行109]
    |       +-- paramValidations() [行121, 150]
    |       +-- validateAndSetRequestedMetrics() [行125, 135]
    |       +-- ClusterStatsRequest構築
    |
    +-- NodeClient.admin().cluster().clusterStats() [行106]
            |
            +-- TransportClusterStatsAction
                    +-- 各ノードへのリクエスト分散
                    +-- 結果の集約
                    +-- NodesResponseRestListener でレスポンス構築
```

### データフロー図

```
[入力]                              [処理]                              [出力]

GET /_cluster/stats           --> RestClusterStatsAction          --> ClusterStatsResponse
  /{metric}                         |                                    |
  /{index_metric}                   +-- メトリクス解析・検証              +-- cluster_name
  /nodes/{nodeId}                   +-- ClusterStatsRequest構築          +-- status
  ?timeout=...                      +-- ノード分散実行                   +-- indices{}
                                    +-- 結果集約                         +-- nodes{}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterStatsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterStatsAction.java` | ソース | RESTハンドラ |
| ClusterStatsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsRequest.java` | ソース | リクエストデータモデル |
| ClusterStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/ClusterStatsResponse.java` | ソース | レスポンスデータモデル |
| TransportClusterStatsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/stats/TransportClusterStatsAction.java` | ソース | トランスポートアクション |
| cluster.stats.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.stats.json` | 設定 | REST API仕様定義 |
