# 画面設計書 93-クラスタ設定取得

## 概要

本ドキュメントは、OpenSearchのCluster Get Settings API（`GET /_cluster/settings`）の画面設計書である。クラスタレベルの設定情報を取得するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、クラスタレベルで設定されたpersistent（永続）設定とtransient（一時）設定をJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：クラスタの運用管理において、現在適用されている設定を確認することは日常的な作業である。本APIにより、管理者はクラスタレベルの動的設定（シャードアロケーション、リカバリ設定など）の現在値を把握できる。設定変更前の確認や、障害調査時の設定状態の確認に利用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cluster/settings` にリクエストを送信する。

**主要な操作・処理内容**：
1. persistent設定とtransient設定の取得
2. `include_defaults=true` 指定時にデフォルト設定を含めた全設定の取得
3. `flat_settings=true` 指定時にフラット形式での設定取得

**画面遷移**：本APIで現在の設定を確認した後、クラスタ設定更新（No.94）で設定変更を行う。クラスタヘルス（No.90）やクラスタ状態（No.91）と合わせて運用状態を把握する。

**権限による表示制御**：クラスタ設定の取得にはクラスタレベルの読み取り権限が必要。SettingsFilterにより、セキュアな設定はフィルタリングされて返却されない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | クラスタ設定管理 | 主機能 | クラスタレベルの設定を返す処理 |

## 画面種別

詳細（REST API レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cluster/settings` | クラスタ設定を取得 |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | いいえ | false | 設定をフラット形式で返す |
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）クラスタマネージャノードへの接続タイムアウト |
| timeout | time | いいえ | - | 明示的な操作タイムアウト |
| include_defaults | boolean | いいえ | false | デフォルトのクラスタ設定を含めて返すか |

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| persistent | object | 永続設定（クラスタ再起動後も保持される） |
| transient | object | 一時設定（クラスタ再起動で消失する） |
| defaults | object | デフォルト設定（`include_defaults=true` の場合のみ） |

## イベント仕様

### 1-クラスタ設定取得

クライアントからGETリクエストを受信すると、以下の処理が実行される。

1. `RestClusterGetSettingsAction.prepareRequest()` でリクエストパラメータを解析
2. 内部的に `ClusterStateRequest` を構築（`routingTable(false).nodes(false)` で不要な情報を除外）
3. クラスタ状態からメタデータを取得し、persistent設定とtransient設定を抽出
4. `SettingsFilter` でセキュアな設定をフィルタリング
5. `include_defaults=true` の場合、`ClusterSettings.diff()` でデフォルト設定との差分を算出
6. `ClusterGetSettingsResponse` を構築して返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラスタ設定取得 | - | SELECT（読み取りのみ） | クラスタ状態のメタデータからpersistent/transient設定を取得。書き込みなし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + 設定JSON | 正常に設定を取得できた場合 |
| - | 警告（非推奨） | master_timeout非推奨メッセージ | master_timeoutパラメータを使用した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| クラスタマネージャ不在 | 503 | クラスタマネージャノードに接続できない場合 |
| タイムアウト | 408 | クラスタマネージャへの接続がタイムアウトした場合 |

## 備考

- 本APIは内部的にCluster State APIを利用してメタデータを取得している。
- `SettingsFilter` により、暗号化されたパスワード等のセキュアな設定は自動的にフィルタリングされる。
- 本APIは CircuitBreaker をトリップしない（`canTripCircuitBreaker()` が `false`）。
- `include_defaults` パラメータを使用すると、明示的に設定されていないデフォルト値も確認できる。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterGetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterGetSettingsResponse.java` | レスポンスの構成（persistentSettings, transientSettings, defaultSettings） |
| 1-2 | Settings.java | `server/src/main/java/org/opensearch/common/settings/Settings.java` | 設定値のデータ構造 |

**読解のコツ**: `ClusterGetSettingsResponse` は `ToXContentObject` を実装しており、toXContent メソッドでpersistent, transient, defaultsの3セクションに分けてシリアライズされる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterGetSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterGetSettingsAction.java` | RESTハンドラ。ClusterStateRequestを構築して設定を取得 |

**主要処理フロー**:
1. **行82**: `routes()` で `GET /_cluster/settings` を登録
2. **行91-105**: `prepareRequest()` でClusterStateRequestを構築（routingTable=false, nodes=false）
3. **行93**: `include_defaults` パラメータの読み取り
4. **行99-104**: クラスタ状態取得後、`renderResponse()` でレスポンスを構築
5. **行117-120**: `renderResponse()` が `response()` 静的メソッドを呼び出し
6. **行122-134**: `response()` でpersistent/transient設定を抽出し、SettingsFilterを適用

#### Step 3: 設定フィルタリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SettingsFilter.java | `server/src/main/java/org/opensearch/common/settings/SettingsFilter.java` | セキュアな設定のフィルタリングロジック |
| 3-2 | ClusterSettings.java | `server/src/main/java/org/opensearch/common/settings/ClusterSettings.java` | クラスタレベルの設定定義とデフォルト値差分算出 |

### プログラム呼び出し階層図

```
RestClusterGetSettingsAction.prepareRequest() [行91]
    |
    +-- ClusterStateRequest構築 [行92]
    |       +-- routingTable(false), nodes(false)
    |
    +-- NodeClient.admin().cluster().state() [行99]
            |
            +-- TransportClusterStateAction
                    |
                    +-- ClusterState取得
                            |
                            +-- RestBuilderListener.buildResponse() [行101]
                                    +-- renderResponse() [行102]
                                            +-- response() [行119]
                                                    +-- settingsFilter.filter() [行130-131]
                                                    +-- clusterSettings.diff() [行132]
                                                    +-- ClusterGetSettingsResponse構築 [行129]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

GET /_cluster/settings    --> RestClusterGetSettingsAction          --> ClusterGetSettingsResponse
  ?include_defaults=...         |                                        |
  ?flat_settings=...            +-- ClusterStateRequest構築              +-- persistent{}
                                +-- ClusterState取得                     +-- transient{}
                                +-- Metadata.persistentSettings()        +-- defaults{}
                                +-- Metadata.transientSettings()              (include_defaults時)
                                +-- SettingsFilter適用
                                +-- ClusterSettings.diff()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterGetSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterGetSettingsAction.java` | ソース | RESTハンドラ |
| ClusterGetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterGetSettingsResponse.java` | ソース | レスポンスデータモデル |
| SettingsFilter.java | `server/src/main/java/org/opensearch/common/settings/SettingsFilter.java` | ソース | 設定フィルタリング |
| ClusterSettings.java | `server/src/main/java/org/opensearch/common/settings/ClusterSettings.java` | ソース | クラスタ設定定義 |
| cluster.get_settings.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_settings.json` | 設定 | REST API仕様定義 |
