# 画面設計書 94-クラスタ設定更新

## 概要

本ドキュメントは、OpenSearchのCluster Update Settings API（`PUT /_cluster/settings`）の画面設計書である。クラスタレベルの動的設定を更新するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、クラスタレベルの動的設定をpersistent（永続）またはtransient（一時）として更新するエンドポイントである。

**業務上の目的・背景**：クラスタの運用中に、再起動なしで動的に設定を変更する必要がある場面は多い。例えば、シャードアロケーションの有効化/無効化、リカバリ速度の調整、ウォーターマーク閾値の変更などが該当する。persistent設定はクラスタ再起動後も保持され、transient設定はクラスタ再起動で消失する。

**画面へのアクセス方法**：HTTPクライアントから `PUT /_cluster/settings` にリクエストボディ付きでリクエストを送信する。

**主要な操作・処理内容**：
1. persistent設定の更新（クラスタ再起動後も保持）
2. transient設定の更新（クラスタ再起動で消失）
3. 設定値を `null` に設定することでデフォルト値にリセット

**画面遷移**：クラスタ設定取得（No.93）で現在の設定を確認した後に本APIで設定変更を行う。変更後、クラスタヘルス（No.90）やクラスタ状態（No.91）で変更の影響を確認する。

**権限による表示制御**：クラスタ設定の更新にはクラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | クラスタ設定管理 | 主機能 | クラスタレベルの動的設定を更新する処理 |

## 画面種別

編集（REST API リクエスト/レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| PUT | `/_cluster/settings` | クラスタ設定を更新 |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| flat_settings | boolean | いいえ | false | 設定をフラット形式で返す |
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）クラスタマネージャノードへの接続タイムアウト |
| timeout | time | いいえ | 30s | 操作タイムアウト |

### リクエストボディ（必須）

| フィールド | 型 | 必須 | 説明 |
|-----------|------|------|------|
| persistent | object | いいえ | 永続設定（クラスタ再起動後も保持） |
| transient | object | いいえ | 一時設定（クラスタ再起動で消失） |

### リクエストボディ例

```json
{
  "persistent": {
    "cluster.routing.allocation.enable": "all"
  },
  "transient": {
    "cluster.routing.allocation.disk.watermark.low": "85%"
  }
}
```

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| acknowledged | boolean | リクエストが受理されたか |
| persistent | object | 更新後の永続設定 |
| transient | object | 更新後の一時設定 |

## イベント仕様

### 1-クラスタ設定更新

クライアントからPUTリクエストを受信すると、以下の処理が実行される。

1. `RestClusterUpdateSettingsAction.prepareRequest()` でリクエストパラメータを解析
2. `ClusterUpdateSettingsRequest` を構築し、timeout および cluster_manager_timeout を設定
3. リクエストボディをJSONパースし、`persistent` と `transient` セクションを抽出
4. `persistent` が存在する場合、`clusterUpdateSettingsRequest.persistentSettings()` に設定
5. `transient` が存在する場合、`clusterUpdateSettingsRequest.transientSettings()` に設定
6. クラスタマネージャノードで設定更新を実行
7. 更新後の設定を含む `ClusterUpdateSettingsResponse` を返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラスタ設定更新 | クラスタメタデータ | UPDATE | クラスタ状態のメタデータ内の設定を更新。persistent設定は永続化ストアにも反映 |

### テーブル別更新項目詳細

#### クラスタメタデータ

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | persistent_settings | リクエストボディのpersistentセクションの値 | クラスタ再起動後も保持 |
| UPDATE | transient_settings | リクエストボディのtransientセクションの値 | クラスタ再起動で消失 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + acknowledged:true + 更新後設定 | 正常に設定が更新された場合 |
| - | 警告（非推奨） | master_timeout非推奨メッセージ | master_timeoutパラメータを使用した場合 |
| - | エラー | 400 Bad Request | 無効な設定名や値が指定された場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| IllegalArgumentException | 400 | 無効な設定名や値が指定された場合 |
| クラスタマネージャ不在 | 503 | クラスタマネージャノードに接続できない場合 |
| タイムアウト | 408 | 操作がタイムアウトした場合 |
| 権限不足 | 403 | 設定更新権限がない場合 |

## 備考

- リクエストボディは必須である（`body.required: true`）。
- `master_timeout` パラメータは非推奨であり、`cluster_manager_timeout` を使用すること。
- persistent設定はtransient設定よりも優先度が低い。transient設定が存在する場合、同名のpersistent設定は上書きされる。
- 設定値を `null` に設定することで、その設定をデフォルト値にリセットできる。
- 本APIは CircuitBreaker をトリップしない（`canTripCircuitBreaker()` が `false`）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterUpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsRequest.java` | リクエストの構成（transientSettings, persistentSettings） |
| 1-2 | ClusterUpdateSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsResponse.java` | レスポンスの構成（acknowledged, transientSettings, persistentSettings） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterUpdateSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterUpdateSettingsAction.java` | RESTハンドラ。リクエストボディ解析とアクション委譲 |

**主要処理フロー**:
1. **行67**: `routes()` で `PUT /_cluster/settings` を登録
2. **行76-95**: `prepareRequest()` でリクエストを解析
3. **行77-82**: timeout, cluster_manager_timeout の設定
4. **行84-86**: リクエストボディのJSONパース
5. **行87-92**: transient/persistent セクションの抽出と設定
6. **行94**: `client.admin().cluster().updateSettings()` でトランスポートアクション実行

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TransportClusterUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/TransportClusterUpdateSettingsAction.java` | クラスタマネージャでの設定更新処理 |

### プログラム呼び出し階層図

```
RestClusterUpdateSettingsAction.prepareRequest() [行76]
    |
    +-- ClusterUpdateSettingsRequest構築 [行77]
    |       +-- timeout設定 [行78]
    |       +-- clusterManagerNodeTimeout設定 [行79-81]
    |       +-- リクエストボディ解析 [行83-92]
    |
    +-- NodeClient.admin().cluster().updateSettings() [行94]
            |
            +-- TransportClusterUpdateSettingsAction.clusterManagerOperation()
                    +-- ClusterState更新
                    +-- persistent/transient設定の反映
                    +-- ClusterUpdateSettingsResponse構築
```

### データフロー図

```
[入力]                          [処理]                                      [出力]

PUT /_cluster/settings    --> RestClusterUpdateSettingsAction          --> ClusterUpdateSettingsResponse
  Body:                         |                                            |
  { persistent: {...},          +-- JSONパース                               +-- acknowledged
    transient: {...} }          +-- ClusterUpdateSettingsRequest構築          +-- persistent{}
                                +-- TransportAction実行                      +-- transient{}
                                +-- ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterUpdateSettingsAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterUpdateSettingsAction.java` | ソース | RESTハンドラ |
| ClusterUpdateSettingsRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsRequest.java` | ソース | リクエストデータモデル |
| ClusterUpdateSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/ClusterUpdateSettingsResponse.java` | ソース | レスポンスデータモデル |
| TransportClusterUpdateSettingsAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/settings/TransportClusterUpdateSettingsAction.java` | ソース | トランスポートアクション |
| cluster.put_settings.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_settings.json` | 設定 | REST API仕様定義 |
