# 画面設計書 96-クラスタ再ルーティング

## 概要

本ドキュメントは、OpenSearchのCluster Reroute API（`POST /_cluster/reroute`）の画面設計書である。個々のシャードのアロケーションを手動で変更するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、クラスタ内のシャードアロケーションを手動で制御するためのエンドポイントである。シャードの移動、レプリカ割り当てのキャンセル、未割り当てシャードの強制割り当てなどのコマンドを実行できる。

**業務上の目的・背景**：自動アロケーションでは解決できないシャード配置の問題を手動で解決するために使用される。例えば、特定ノードからシャードを退避させるホットスポット対応、未割り当てシャードの強制割り当て、メンテナンス前のシャード移動などの運用シナリオで必要となる。

**画面へのアクセス方法**：HTTPクライアントから `POST /_cluster/reroute` にコマンドを含むリクエストボディを送信する。

**主要な操作・処理内容**：
1. `move` コマンド：割り当て済みシャードを別ノードに移動
2. `cancel` コマンド：シャードの割り当てをキャンセル
3. `allocate_replica` コマンド：未割り当てレプリカシャードを特定ノードに割り当て
4. `allocate_stale_primary` コマンド：古いプライマリシャードデータを使用して割り当て（データロスの可能性あり）
5. `allocate_empty_primary` コマンド：空のプライマリシャードを割り当て（データロスの可能性あり）
6. `dry_run` モード：操作をシミュレーションのみ実行

**画面遷移**：アロケーション説明（No.95）で問題を特定した後、本APIで手動再ルーティングを実行する。実行後、クラスタヘルス（No.90）やクラスタ状態（No.91）で結果を確認する。

**権限による表示制御**：クラスタレベルの管理権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | シャードアロケーション | 主機能 | 個々のシャードのアロケーションを手動で変更する処理 |

## 画面種別

編集（REST API リクエスト/レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| POST | `/_cluster/reroute` | シャードアロケーションの手動変更 |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| dry_run | boolean | いいえ | false | 操作をシミュレーションのみ実行し、結果のクラスタ状態を返す |
| explain | boolean | いいえ | false | コマンドが実行可能/不可能な理由の説明を返す |
| retry_failed | boolean | いいえ | false | 過度な割り当て失敗でブロックされたシャードの割り当てを再試行 |
| metric | list | いいえ | メタデータ以外の全て | レスポンスに含めるクラスタ状態のメトリクス |
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）クラスタマネージャノードへの接続タイムアウト |
| timeout | time | いいえ | - | 操作タイムアウト |

### リクエストボディ（任意）

| フィールド | 型 | 必須 | 説明 |
|-----------|------|------|------|
| commands | array | いいえ | 実行するアロケーションコマンドの配列 |
| dry_run | boolean | いいえ | ボディでもdry_run指定可能 |

### リクエストボディ例

```json
{
  "commands": [
    {
      "move": {
        "index": "my-index",
        "shard": 0,
        "from_node": "node1",
        "to_node": "node2"
      }
    }
  ]
}
```

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| acknowledged | boolean | リクエストが受理されたか |
| state | object | 再ルーティング後のクラスタ状態（metricパラメータに応じてフィルタリング） |
| explanations | array | コマンドの実行可否の説明（`explain=true` の場合） |

## イベント仕様

### 1-クラスタ再ルーティング

クライアントからPOSTリクエストを受信すると、以下の処理が実行される。

1. `RestClusterRerouteAction.prepareRequest()` でリクエストパラメータを解析
2. `createRequest()` で `ClusterRerouteRequest` を構築
3. リクエストボディを `ObjectParser` でパースし、`AllocationCommands` を抽出
4. `dry_run`、`explain`、`retry_failed`、`timeout` パラメータを設定
5. `metric` パラメータが未指定の場合、メタデータ以外の全メトリクスをデフォルトとして設定
6. `SettingsFilter` でセキュアな設定をフィルタリング
7. クラスタマネージャノードでアロケーションコマンドを実行
8. 再ルーティング後のクラスタ状態を含むレスポンスを返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| クラスタ再ルーティング | クラスタ状態（RoutingTable） | UPDATE | シャードのルーティング情報を更新 |
| dry_run実行 | - | SELECT | シミュレーションのみ実行。実際の更新なし |

### テーブル別更新項目詳細

#### クラスタ状態（RoutingTable）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| UPDATE | シャードルーティング | コマンドに応じたシャード配置の変更 | move/cancel/allocateコマンドにより更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + acknowledged:true + クラスタ状態 | 正常にルーティングが変更された場合 |
| - | 警告（非推奨） | master_nodeメトリクス非推奨メッセージ | metricパラメータにmaster_nodeを指定した場合 |
| - | エラー | 400 Bad Request | 無効なコマンドが指定された場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| IllegalArgumentException | 400 | 無効なコマンドパラメータ（存在しないノード、インデックス等） |
| ClusterBlockException | 400 | クラスタがブロック状態で操作が禁止されている場合 |
| タイムアウト | 408 | 操作がタイムアウトした場合 |

## 備考

- `master_node` メトリクスは非推奨であり、`cluster_manager_node` を使用すること。
- `metric` パラメータのデフォルトは、メタデータを除く全てのメトリクスである。
- `SettingsFilter` により、レスポンスのクラスタ状態からセキュアな設定が除外される。
- リクエストボディの `ObjectParser` は `commands` 配列と `dry_run` フィールドを解析する。
- `explain=true` の場合、コマンドの実行可否の理由が詳細に返却される。
- システムインデックスへのアクセスがデフォルトで許可されている。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterRerouteRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/reroute/ClusterRerouteRequest.java` | リクエスト構成（commands, dryRun, explain, retryFailed） |
| 1-2 | AllocationCommands.java | `server/src/main/java/org/opensearch/cluster/routing/allocation/command/AllocationCommands.java` | move/cancel/allocateコマンドの定義 |
| 1-3 | ClusterRerouteResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/reroute/ClusterRerouteResponse.java` | レスポンス構成 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestClusterRerouteAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterRerouteAction.java` | RESTハンドラ。ObjectParserによるボディ解析 |

**主要処理フロー**:
1. **行95**: `routes()` で `POST /_cluster/reroute` を登録
2. **行109-129**: `prepareRequest()` でリクエスト解析
3. **行110**: `createRequest()` で `ClusterRerouteRequest` を構築
4. **行67-75**: `ObjectParser` で `commands` と `dry_run` をパース
5. **行116-127**: metricパラメータの処理（デフォルト: メタデータ以外の全て）
6. **行128**: `client.admin().cluster().reroute()` でトランスポートアクション実行

### プログラム呼び出し階層図

```
RestClusterRerouteAction.prepareRequest() [行109]
    |
    +-- createRequest() [行110, 145]
    |       +-- ClusterRerouteRequest構築 [行146]
    |       +-- dry_run, explain, retry_failed設定 [行147-150]
    |       +-- PARSER.parse() [行155]
    |              +-- AllocationCommands.fromXContent()
    |
    +-- SettingsFilter.addFilterSettingParams() [行111]
    +-- metricパラメータ処理 [行116-127]
    |
    +-- NodeClient.admin().cluster().reroute() [行128]
            |
            +-- TransportClusterRerouteAction
                    +-- AllocationCommands実行
                    +-- ClusterState更新
                    +-- ClusterRerouteResponse構築
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

POST /_cluster/reroute    --> RestClusterRerouteAction              --> ClusterRerouteResponse
  ?dry_run=true                 |                                        |
  ?explain=true                 +-- リクエスト解析                        +-- acknowledged
  ?metric=...                   +-- AllocationCommands抽出               +-- state{}
  Body: { commands: [...] }     +-- コマンド実行                         +-- explanations[]
                                +-- ClusterState更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestClusterRerouteAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterRerouteAction.java` | ソース | RESTハンドラ |
| ClusterRerouteRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/reroute/ClusterRerouteRequest.java` | ソース | リクエストデータモデル |
| AllocationCommands.java | `server/src/main/java/org/opensearch/cluster/routing/allocation/command/AllocationCommands.java` | ソース | アロケーションコマンド定義 |
| TransportClusterRerouteAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/reroute/TransportClusterRerouteAction.java` | ソース | トランスポートアクション |
| cluster.reroute.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.reroute.json` | 設定 | REST API仕様定義 |
