# 画面設計書 97-保留中タスク

## 概要

本ドキュメントは、OpenSearchのPending Cluster Tasks API（`GET /_cluster/pending_tasks`）の画面設計書である。未実行のクラスタレベル変更のリストを取得するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、クラスタマネージャノードのキューに保留されている未実行のクラスタレベル変更（インデックス作成、マッピング更新、シャード割り当て/失敗など）のリストをJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：クラスタの応答性やパフォーマンスの問題を診断する際に、クラスタマネージャノードの処理キューの状態を確認する必要がある。大量の保留中タスクは、クラスタマネージャノードの過負荷やクラスタの不安定性を示す指標となる。本APIにより、タスクの種類、優先度、キュー内での待機時間を確認できる。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cluster/pending_tasks` にリクエストを送信する。

**主要な操作・処理内容**：
1. 保留中のクラスタレベルタスクの一覧取得
2. ローカルノードの情報のみを返す（`local=true`）

**画面遷移**：クラスタヘルス（No.90）でクラスタの応答が遅い場合に本APIで保留中タスクを確認する。保留中タスクが多い場合、クラスタ設定更新（No.94）でタスクキューの調整を行う。

**権限による表示制御**：クラスタレベルのモニタリング権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 51 | タスク管理 | 主機能 | 未実行のクラスタレベル変更のリストを返す処理 |

## 画面種別

一覧（REST API レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cluster/pending_tasks` | 保留中のクラスタタスクを取得 |

## 入出力項目

### クエリパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| local | boolean | いいえ | false | ローカルノードの情報を返す（クラスタマネージャから取得しない） |
| cluster_manager_timeout | time | いいえ | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | いいえ | 30s | （非推奨）クラスタマネージャノードへの接続タイムアウト |

## 表示項目

### レスポンスフィールド

| フィールド | 型 | 説明 |
|-----------|------|------|
| tasks | array | 保留中タスクの配列 |
| tasks[].insert_order | number | タスクの挿入順序 |
| tasks[].priority | string | タスクの優先度（IMMEDIATE, URGENT, HIGH, NORMAL, LOW, LANGUID） |
| tasks[].source | string | タスクのソース（タスクの種類を示す文字列） |
| tasks[].executing | boolean | タスクが現在実行中か |
| tasks[].time_in_queue_millis | number | キューでの待機時間（ミリ秒） |
| tasks[].time_in_queue | string | キューでの待機時間（人間可読形式） |

## イベント仕様

### 1-保留中タスク取得

クライアントからGETリクエストを受信すると、以下の処理が実行される。

1. `RestPendingClusterTasksAction.prepareRequest()` でリクエストパラメータを解析
2. `PendingClusterTasksRequest` を構築し、`cluster_manager_timeout` と `local` パラメータを設定
3. クラスタマネージャノードから保留中タスクの一覧を取得
4. `RestToXContentListener` でレスポンスを構築して返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保留中タスク取得 | - | SELECT（読み取りのみ） | クラスタマネージャのタスクキューからタスク一覧を取得。書き込みなし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + タスク一覧JSON | 正常に保留中タスクを取得できた場合 |
| - | 警告（非推奨） | master_timeout非推奨メッセージ | master_timeoutパラメータを使用した場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| クラスタマネージャ不在 | 503 | クラスタマネージャノードに接続できない場合 |
| タイムアウト | 408 | クラスタマネージャへの接続がタイムアウトした場合 |

## 備考

- 保留中タスクが空の場合、`tasks` 配列は空配列として返される。
- `master_timeout` パラメータは非推奨であり、`cluster_manager_timeout` を使用すること。
- `local=true` の場合、ローカルノードが認識している保留中タスクが返される（クラスタマネージャノードの実際のキューとは異なる場合がある）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | リクエスト構成（local, clusterManagerTimeout） |
| 1-2 | PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | レスポンス構成（pendingTasks配列） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPendingClusterTasksAction.java` | RESTハンドラ |

**主要処理フロー**:
1. **行59**: `routes()` で `GET /_cluster/pending_tasks` を登録
2. **行68-76**: `prepareRequest()` でリクエスト解析
3. **行69**: `PendingClusterTasksRequest` の構築
4. **行70-71**: `cluster_manager_timeout` の設定
5. **行73**: `master_timeout` の非推奨パラメータ処理
6. **行74**: `local` パラメータの設定
7. **行75**: `client.admin().cluster().pendingClusterTasks()` でトランスポートアクション実行

### プログラム呼び出し階層図

```
RestPendingClusterTasksAction.prepareRequest() [行68]
    |
    +-- PendingClusterTasksRequest構築 [行69]
    |       +-- clusterManagerNodeTimeout設定 [行70-71]
    |       +-- master_timeout非推奨処理 [行73]
    |       +-- local設定 [行74]
    |
    +-- NodeClient.admin().cluster().pendingClusterTasks() [行75]
            |
            +-- TransportPendingClusterTasksAction
                    +-- クラスタマネージャのタスクキュー取得
                    +-- PendingClusterTasksResponse構築
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

GET /_cluster/pending_tasks   --> RestPendingClusterTasksAction        --> PendingClusterTasksResponse
  ?local=false                      |                                        |
  ?cluster_manager_timeout=30s      +-- PendingClusterTasksRequest構築       +-- tasks[]
                                    +-- TransportAction実行                       +-- insert_order
                                    +-- タスクキュー取得                           +-- priority
                                                                                  +-- source
                                                                                  +-- time_in_queue
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPendingClusterTasksAction.java` | ソース | RESTハンドラ |
| PendingClusterTasksRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java` | ソース | リクエストデータモデル |
| PendingClusterTasksResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java` | ソース | レスポンスデータモデル |
| TransportPendingClusterTasksAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/tasks/TransportPendingClusterTasksAction.java` | ソース | トランスポートアクション |
| cluster.pending_tasks.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.pending_tasks.json` | 設定 | REST API仕様定義 |
