# 画面設計書 98-リモートクラスタ情報

## 概要

本ドキュメントは、OpenSearchのRemote Cluster Info API（`GET /_remote/info`）の画面設計書である。設定されたリモートクラスタの情報を取得するためのREST APIエンドポイントについて、入出力仕様・処理フロー・例外処理を定義する。

### 本画面の処理概要

本APIは、クロスクラスタ検索やクロスクラスタレプリケーションで使用されるリモートクラスタの接続設定情報をJSON形式で返却するエンドポイントである。

**業務上の目的・背景**：複数のOpenSearchクラスタを運用している環境では、クロスクラスタ検索（Cross-Cluster Search）を利用してリモートクラスタのデータにアクセスすることがある。本APIにより、設定されたリモートクラスタの接続状態、シードノード、接続モードなどの情報を確認できる。リモートクラスタの接続トラブルシューティングに使用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_remote/info` にリクエストを送信する。

**主要な操作・処理内容**：
1. 設定されたリモートクラスタの一覧と接続情報の取得

**画面遷移**：クラスタ設定取得（No.93）でリモートクラスタの設定を確認し、本APIで接続状態を確認する。問題がある場合はクラスタ設定更新（No.94）でリモートクラスタの設定を変更する。

**権限による表示制御**：クラスタレベルのモニタリング権限が必要である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | リモートクラスタ接続 | 主機能 | 設定されたリモートクラスタの情報を返す処理 |

## 画面種別

一覧（REST API レスポンス）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_remote/info` | リモートクラスタ情報を取得 |

## 入出力項目

### クエリパラメータ

本APIにはクエリパラメータはない。

## 表示項目

### レスポンスフィールド

レスポンスはリモートクラスタ名をキーとするオブジェクトである。

| フィールド | 型 | 説明 |
|-----------|------|------|
| {cluster_name} | object | リモートクラスタの情報 |
| {cluster_name}.connected | boolean | リモートクラスタに接続されているか |
| {cluster_name}.mode | string | 接続モード（sniff, proxy等） |
| {cluster_name}.seeds | array | シードノードのアドレス一覧 |
| {cluster_name}.num_nodes_connected | number | 接続されているノード数 |
| {cluster_name}.max_connections_per_cluster | number | クラスタあたりの最大接続数 |
| {cluster_name}.initial_connect_timeout | string | 初期接続タイムアウト |
| {cluster_name}.skip_unavailable | boolean | 利用不可時にスキップするか |

## イベント仕様

### 1-リモートクラスタ情報取得

クライアントからGETリクエストを受信すると、以下の処理が実行される。

1. `RestRemoteClusterInfoAction.prepareRequest()` でリクエストを処理
2. `RemoteInfoAction.INSTANCE` トランスポートアクションを `RemoteInfoRequest` で実行
3. リモートクラスタの接続設定と状態を収集
4. `RestToXContentListener` でレスポンスをJSON形式にシリアライズして返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リモートクラスタ情報取得 | - | SELECT（読み取りのみ） | リモートクラスタの接続設定と状態を読み取り。書き込みなし |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データの更新は発生しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|---------|
| - | 成功 | 200 OK + リモートクラスタ情報JSON | 正常に情報を取得できた場合 |
| - | 成功 | 200 OK + 空オブジェクト `{}` | リモートクラスタが設定されていない場合 |

## 例外処理

| 例外 | HTTPステータス | 説明 |
|------|---------------|------|
| 特になし | - | 本APIは単純な読み取りAPIであり、特別な例外処理はない |

## 備考

- 本APIは CircuitBreaker をトリップしない（`canTripCircuitBreaker()` が `false`）。
- パラメータが一切存在しないシンプルなAPIである。
- リモートクラスタが設定されていない場合、空のJSONオブジェクトが返される。
- `RemoteInfoAction.INSTANCE` を使用して直接トランスポートアクションを実行する（通常のadmin().cluster()パターンとは異なる）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RemoteInfoRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoRequest.java` | リクエスト（パラメータなしの単純なリクエスト） |
| 1-2 | RemoteInfoResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoResponse.java` | レスポンス構成（RemoteConnectionInfo一覧） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestRemoteClusterInfoAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRemoteClusterInfoAction.java` | RESTハンドラ。非常にシンプルな実装 |

**主要処理フロー**:
1. **行56**: `routes()` で `GET /_remote/info` を登録
2. **行65-67**: `prepareRequest()` で `RemoteInfoAction.INSTANCE` を直接実行
3. **行66**: `new RemoteInfoRequest()` でパラメータなしのリクエストを構築

#### Step 3: トランスポートアクション層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RemoteInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoAction.java` | アクション定義 |
| 3-2 | TransportRemoteInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/TransportRemoteInfoAction.java` | リモートクラスタ情報の収集処理 |

### プログラム呼び出し階層図

```
RestRemoteClusterInfoAction.prepareRequest() [行65]
    |
    +-- NodeClient.execute() [行66]
            +-- RemoteInfoAction.INSTANCE
            +-- new RemoteInfoRequest()
            |
            +-- TransportRemoteInfoAction
                    +-- リモートクラスタ接続設定の収集
                    +-- RemoteConnectionInfoの構築
                    +-- RemoteInfoResponse構築
                            |
                            +-- RestToXContentListener [行66]
```

### データフロー図

```
[入力]                      [処理]                                [出力]

GET /_remote/info     --> RestRemoteClusterInfoAction        --> RemoteInfoResponse
                            |                                      |
                            +-- RemoteInfoRequest構築              +-- {cluster1}: {connected, mode, seeds, ...}
                            +-- TransportAction実行                +-- {cluster2}: {connected, mode, seeds, ...}
                            +-- リモートクラスタ情報収集
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestRemoteClusterInfoAction.java | `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestRemoteClusterInfoAction.java` | ソース | RESTハンドラ |
| RemoteInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoAction.java` | ソース | アクション定義 |
| RemoteInfoRequest.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoRequest.java` | ソース | リクエストデータモデル |
| RemoteInfoResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/RemoteInfoResponse.java` | ソース | レスポンスデータモデル |
| TransportRemoteInfoAction.java | `server/src/main/java/org/opensearch/action/admin/cluster/remote/TransportRemoteInfoAction.java` | ソース | トランスポートアクション |
| cluster.remote_info.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.remote_info.json` | 設定 | REST API仕様定義 |
