---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：101-重み付きルーティング取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_weighted_routing.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterGetWeightedRoutingAction.java` - RESTアクション実装
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/get/ClusterGetWeightedRoutingRequest.java` - リクエストクラス
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/get/ClusterGetWeightedRoutingResponse.java` - レスポンスクラス
- E-05: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/get/TransportGetWeightedRoutingAction.java` - Transport実装
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `GET /_cluster/routing/awareness/{attribute}/weights` | E-01, E-02 (行38) | ○ |
| C-02 | パスパラメータ `attribute` はアウェアネス属性名 | E-01, E-03 (行29-33) | ○ |
| C-03 | レスポンスに weights, _version, discovered_cluster_manager が含まれる | E-04 (行100-116 toXContent) | ○ |
| C-04 | `local` クエリパラメータをサポート | E-02 (行49) | ○ |
| C-05 | ClusterManagerNodeReadAction を継承 | E-05 (行36-38) | ○ |
| C-06 | METADATA_READ ブロックチェックを実施 | E-05 (行75-77) | ○ |
| C-07 | WeightedRoutingService.verifyAwarenessAttribute() で属性検証 | E-05 (行86) | ○ |
| C-08 | ClusterState.metadata().custom(WeightedRoutingMetadata.TYPE) からメタデータ取得 | E-05 (行87) | ○ |
| C-09 | 重み未設定時は空レスポンス | E-05 (行88-96) | ○ |
| C-10 | @PublicApi(since = "2.4.0") アノテーション | E-03 (行26-27), E-04 (行34) | ○ |
| C-11 | バリデーション: 属性名がnullまたは空の場合エラー | E-03 (行57-63) | ○ |
| C-12 | 関連機能No.58 重み付きルーティング | E-06 (行135) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] APIスペック(E-01)とREST実装(E-02)のルート定義が一致しているか確認
- [ ] レスポンスフィールド(C-03)がtoXContent実装と整合しているか確認
- [ ] バリデーションエラーメッセージが正確か確認
