---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-重み付きルーティング設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_weighted_routing.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterPutWeightedRoutingAction.java` - RESTアクション実装
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/put/ClusterPutWeightedRoutingRequest.java` - リクエストクラス
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/put/TransportAddWeightedRoutingAction.java` - Transport実装
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `PUT /_cluster/routing/awareness/{attribute}/weights` | E-01, E-02 (行38) | ○ |
| C-02 | リクエストボディに weights と _version が必要 | E-03 (行116-159 setWeightedRouting) | ○ |
| C-03 | 属性名が空の場合バリデーションエラー | E-03 (行171-173) | ○ |
| C-04 | 重みが空の場合バリデーションエラー | E-03 (行174-176) | ○ |
| C-05 | バージョンが未設定の場合バリデーションエラー | E-03 (行177-179) | ○ |
| C-06 | 重み値がnullの場合バリデーションエラー | E-03 (行185) | ○ |
| C-07 | 重み値が数値でない場合バリデーションエラー | E-03 (行191-193) | ○ |
| C-08 | ゼロ重み数が全数の半分超でバリデーションエラー | E-03 (行198-209) | ○ |
| C-09 | 空のリクエストボディで "Empty request body" エラー | E-03 (行86-88) | ○ |
| C-10 | createRequest() でパスパラメータとボディを解析 | E-02 (行52-56) | ○ |
| C-11 | @PublicApi(since = "2.4.0") | E-03 (行43) | ○ |
| C-12 | ClusterManagerNodeRequest を継承 | E-03 (行44) | ○ |
| C-13 | 楽観的排他制御にバージョンを使用 | E-03 (行49-57, 177-179) | ○ |
| C-14 | 関連機能No.58 重み付きルーティング | E-05 (行136) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルール(C-03〜C-08)がソースコードと整合しているか確認
- [ ] ゼロ重み制約(C-08)のロジック（半分以下）が正確か確認
- [ ] リクエストボディの解析ロジックが正確に記述されているか確認
