---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-重み付きルーティング削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_weighted_routing.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterDeleteWeightedRoutingAction.java` - RESTアクション実装
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DELETEエンドポイントが2つ存在する | E-01, E-02 (行39-44) | ○ |
| C-02 | `/_cluster/routing/awareness/weights` パス | E-02 (行41) | ○ |
| C-03 | `/_cluster/routing/awareness/{attribute}/weights` パス | E-02 (行42) | ○ |
| C-04 | attribute パラメータは省略可能 | E-02 (行42), E-01 | ○ |
| C-05 | リクエストボディはオプション | E-02 (行64) | ○ |
| C-06 | createRequest() でリクエスト生成 | E-02 (行60-66) | ○ |
| C-07 | NodeClient経由でTransport層に委譲 | E-02 (行55-57) | ○ |
| C-08 | 関連機能No.58 重み付きルーティング | E-03 (行137) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 2つのDELETEパスが正確に記述されているか確認
- [ ] リクエストボディのオプション性が正しいか確認
