---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：104-デコミッション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **デコミッションステージ遷移**：Transport層内部のステージ遷移詳細は未読

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_decommission_awareness.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDecommissionAction.java` - RESTアクション実装
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは `PUT /_cluster/decommission/awareness/{name}/{value}` | E-01, E-02 (行35) | ○ |
| C-02 | パスパラメータに awareness_attribute_name と awareness_attribute_value | E-01, E-02 (行51-52) | ○ |
| C-03 | `no_delay` クエリパラメータをサポート | E-02 (行54) | ○ |
| C-04 | `delay_timeout` クエリパラメータをサポート | E-02 (行57-59) | ○ |
| C-05 | DEFAULT_NODE_DRAINING_TIMEOUT がデフォルト | E-02 (行58) | ○ |
| C-06 | DecommissionAttribute を構築してリクエストに設定 | E-02 (行61) | ○ |
| C-07 | APIはexperimental ステータス | E-01 (stability: experimental) | ○ |
| C-08 | デコミッション処理は DRAINING -> IN_PROGRESS -> SUCCESSFUL のステージを経る | **根拠なし** | △ |
| C-09 | 関連機能No.54 ノードデコミッション | E-03 (行138) | ○ |
| C-10 | NodeClient経由でTransport層に委譲 | E-02 (行46) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-08: デコミッションのステージ遷移詳細はTransportDecommissionAction.java およびDecommissionService.javaの内部実装を参照する必要がある
  - 候補：`DecommissionService.java` / `DecommissionStatus.java` / TransportDecommissionAction内部

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - デコミッションステージ遷移の詳細はTransport層内部の未読ファイルに依存

## 6) レビュアーチェックリスト（最小）
- [ ] デコミッションステージ遷移(C-08)がDecommissionService実装と整合しているか確認
- [ ] delay_timeoutのデフォルト値がDEFAULT_NODE_DRAINING_TIMEOUTの実際の値と一致するか確認
- [ ] no_delayパラメータの動作がTransport層と整合しているか確認
