---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-ノード情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.info.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesInfoAction.java` - RESTアクション実装
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのGETルートが定義されている | E-02 (行68-78) | ○ |
| C-02 | メトリクスは settings, os, process, jvm, thread_pool, transport, http, plugins, ingest | E-01 (options配列) | ○ |
| C-03 | nodeIdがメトリクス名のみの場合、メトリクスフィルタとして扱う | E-02 (行98-111) | ○ |
| C-04 | ALLOWED_METRICS に NodesInfoRequest.Metric.allMetrics() を使用 | E-02 (行59) | ○ |
| C-05 | flat_settings クエリパラメータをサポート | E-01 (params.flat_settings) | ○ |
| C-06 | timeout クエリパラメータをサポート | E-01 (params.timeout), E-02 (行89) | ○ |
| C-07 | SettingsFilter でセキュリティ設定をフィルタリング | E-02 (行61-65, 90) | ○ |
| C-08 | canTripCircuitBreaker() が false を返す | E-02 (行137-139) | ○ |
| C-09 | Settings.FORMAT_PARAMS を responseParams に使用 | E-02 (行132-134) | ○ |
| C-10 | 不明メトリクスは無視される（retainAll） | E-02 (行125) | ○ |
| C-11 | _all メトリクスで全情報を有効化 | E-02 (行120-121) | ○ |
| C-12 | 関連機能No.49 ノード情報・統計 | E-03 (行141) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] メトリクス一覧(C-02)がAPIスペックと実装の両方と整合しているか確認
- [ ] nodeId/metrics判別ロジック(C-03)が正確に記述されているか確認
- [ ] SettingsFilterの動作(C-07)が正確か確認
