---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-ノード統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.stats.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesStatsAction.java` - RESTアクション実装
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6つのGETルートが定義されている | E-02 (行67-78) | ○ |
| C-02 | METRICSマップでメトリクスハンドラを定義 | E-02 (行80-89) | ○ |
| C-03 | FLAGSマップでインデックスメトリクスフラグを定義 | E-02 (行91-99) | ○ |
| C-04 | メトリクス: breaker, fs, http, indices, jvm, os, process, thread_pool, transport, discovery, indexing_pressure | E-01 (options配列) | ○ |
| C-05 | インデックスメトリクス: completion, docs, fielddata等 | E-01 (index_metric options) | ○ |
| C-06 | _allと個別メトリクス混在でIllegalArgumentException | E-02 (行127-136) | ○ |
| C-07 | index_metricがindicesメトリクスなしで指定された場合エラー | E-02 (行198-207) | ○ |
| C-08 | cachesメトリクスでCacheType別統計をサポート | E-02 (行179-197) | ○ |
| C-09 | level パラメータ（indices/node/shards） | E-01 (params.level), E-02 (行233-235) | ○ |
| C-10 | include_segment_file_sizes パラメータ | E-01 (params.include_segment_file_sizes), E-02 (行222-223) | ○ |
| C-11 | canTripCircuitBreaker() が false を返す | E-02 (行248-250) | ○ |
| C-12 | responseParams に "level" を含む | E-02 (行240-244) | ○ |
| C-13 | 不明メトリクス指定で unrecognized エラー | E-02 (行150-152) | ○ |
| C-14 | 関連機能No.49 ノード情報・統計 | E-03 (行142) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] メトリクス一覧(C-04)がAPIスペックとMETRICSマップの両方と整合しているか確認
- [ ] インデックスメトリクス一覧(C-05)がFLAGSマップと整合しているか確認
- [ ] cachesメトリクスの動作(C-08)が正確に記述されているか確認
- [ ] エラーメッセージ(C-06, C-07, C-13)が実装と一致するか確認
