---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-複数ドキュメント取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Security権限チェックの詳細**：根拠不足
  2. **HTTPステータスコード403の正確性**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/mget.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestMultiGetAction.java`
- E-03: `server/src/main/java/org/opensearch/action/get/TransportMultiGetAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET/POSTの/_mgetと/{index}/_mgetの4ルート定義 | E-01, E-02 (行66-69) | ○ |
| C-02 | stored_fields, preference, realtime等のクエリパラメータ | E-01 | ○ |
| C-03 | リクエストボディにdocsまたはidsを指定 | E-01 (body description) | ○ |
| C-04 | 廃止されたfieldsパラメータのチェック | E-02 (行83-88) | ○ |
| C-05 | FetchSourceContextによるソースフィルタリング | E-02 (行95) | ○ |
| C-06 | クラスタ状態のグローバルブロックチェック（READ） | E-03 (行92) | ○ |
| C-07 | シャードIDごとのリクエストグループ化 | E-03 (行96-130) | ○ |
| C-08 | セグメントレプリケーション時のプライマリルーティング強制 | E-03 (行85-87, 123-124) | ○ |
| C-09 | AtomicArrayとAtomicIntegerによる非同期結果集約 | E-03 (行94, 145) | ○ |
| C-10 | RoutingMissingExceptionによる個別ドキュメント失敗 | E-03 (行105-111) | ○ |
| C-11 | allowExplicitIndex設定による明示的インデックス指定制御 | E-02 (行59, 62, 97) | ○ |
| C-12 | 関連機能No.11（ドキュメント取得） | E-05 | ○ |
| C-13 | realtimeデフォルト値がtrue | E-01, E-02 (行82) | ○ |
| C-14 | レスポンスがリクエスト順序を保持 | E-03 (行94, 153) | ○ |
| C-15 | 読み取り専用APIでデータ更新なし | E-02, E-03 | ○ |
| C-16 | Security権限チェック（インデックスレベルread権限） | **根拠なし** | △ |
| C-17 | ClusterBlockException時のHTTPステータス403 | **根拠なし** | △ |
| C-18 | bodyが必須 | E-01 (body.required: true) | ○ |

## 4) 不足情報（Unknown / Missing）
- Security権限チェックの詳細はOpenSearch Securityプラグインのコードに依存しており、本プロジェクトのコアコードには含まれていない
  - 候補：security plugin / security configuration / REST layer filter
- ClusterBlockException時の正確なHTTPステータスコードはRestControllerの例外ハンドリングに依存
  - 候補：RestController.java / ExceptionHandler

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義とソースコードの整合性は高い
- 1: 中リスク - Security権限の記述はプラグイン依存のため要確認
- 0: 低リスク - データフローとコードリーディングガイドの記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] C-16: Security権限チェックの記述がSecurityプラグインの実装と整合しているか確認
- [ ] C-17: ClusterBlockException時のHTTPステータスコードが正確か確認
- [ ] パラメータ一覧がmget.jsonの全パラメータを網羅しているか確認
- [ ] レスポンスボディのフィールド一覧が実際の出力と一致しているか確認
