---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-ホットスレッド

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/nodes.hot_threads.json` - APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestNodesHotThreadsAction.java` - RESTアクション実装
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 正規ルートは2つ（`/_nodes/hot_threads`, `/_nodes/{nodeId}/hot_threads`） | E-02 (行113-114) | ○ |
| C-02 | 非推奨ルートが6つ定義されている | E-02 (行99-110) | ○ |
| C-03 | 非推奨パスは7.0.0以降 | E-01 (deprecated.version: 7.0.0) | ○ |
| C-04 | interval パラメータでサンプリング間隔を設定 | E-01 (params.interval), E-02 (行129) | ○ |
| C-05 | snapshots パラメータ（デフォルト10） | E-01 (params.snapshots), E-02 (行130) | ○ |
| C-06 | threads パラメータ（デフォルト3） | E-01 (params.threads), E-02 (行126) | ○ |
| C-07 | ignore_idle_threads パラメータ（デフォルトtrue） | E-01 (params.ignore_idle_threads), E-02 (行127) | ○ |
| C-08 | type パラメータ（cpu/wait/block） | E-01 (params.type.options), E-02 (行128) | ○ |
| C-09 | レスポンスはテキスト形式（JSON形式ではない） | E-02 (行136-143) | ○ |
| C-10 | 各ノードの結果は "::: " プレフィックスで区切られる | E-02 (行139) | ○ |
| C-11 | RestResponseListenerを使用（RestToXContentListenerではない） | E-02 (行134-145) | ○ |
| C-12 | canTripCircuitBreaker() が false を返す | E-02 (行149-151) | ○ |
| C-13 | 関連機能No.49 ノード情報・統計, No.128 スレッドプール管理 | E-03 (行144-145) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] テキスト形式レスポンスの構造(C-09, C-10)が実装と整合しているか確認
- [ ] 非推奨パスの一覧(C-02)が完全か確認
- [ ] パラメータのデフォルト値(C-05, C-06, C-07)がAPIスペックと実装の両方で一致するか確認
