---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：113-タスク取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **完了済みタスクの.tasksインデックス保存仕様**：store_resultの詳細動作確認が必要
  2. **例外処理のHTTPステータス詳細**：404/408の正確な発生条件確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.get.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetTaskAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはGET /_tasks/{task_id} | E-01, E-02 (行番号58) | ○ |
| C-02 | task_idパラメータはstring型でnode_id:task_number形式 | E-01, E-02 (行番号68) | ○ |
| C-03 | wait_for_completionパラメータのデフォルトはfalse | E-01, E-02 (行番号69) | ○ |
| C-04 | timeoutパラメータをサポート | E-01, E-02 (行番号70) | ○ |
| C-05 | GetTaskRequestにsetTaskId, setWaitForCompletion, setTimeoutを設定 | E-02 (行番号72-75) | ○ |
| C-06 | RestToXContentListenerでレスポンスを返す | E-02 (行番号76) | ○ |
| C-07 | APIの安定性はexperimental | E-01 | ○ |
| C-08 | 関連機能は機能No.51（タスク管理） | E-04 | ○ |
| C-09 | 画面No.113、カテゴリはタスク管理 | E-03 | ○ |
| C-10 | レスポンスにcompleted, task, response, errorフィールドを含む | E-02 | ○ |
| C-11 | タスク一覧APIやタスクキャンセルAPIとの画面遷移関係 | E-03 | ○ |
| C-12 | 完了済みタスクは.tasksインデックスに保存される | **根拠なし** | △ |
| C-13 | 例外処理のHTTPステータスコード（404, 408）の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- .tasksインデックスへの保存仕様はTransportGetTaskActionの内部実装に依存
  - 候補：TransportGetTaskAction.java / PersistentTasksService.java
- 例外処理のHTTPステータスはREST共通フレームワークのマッピングに依存
  - 候補：RestController.java / ExceptionHandler

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義、パラメータ、ルーティングは全てソースコードで確認済み
- 1: 中リスク - .tasksインデックスの保存仕様は間接的な知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] .tasksインデックスへのタスク結果保存の条件（store_result）を確認
- [ ] タスクが見つからない場合の正確なHTTPステータスコードを確認
- [ ] wait_for_completionとtimeoutの組み合わせ動作を確認
