---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：114-タスクキャンセル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **キャンセル不可タスクの例外処理詳細**：具体的なHTTPステータスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/tasks.cancel.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCancelTasksAction.java`
- E-03: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestListTasksAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはPOST /_tasks/_cancelとPOST /_tasks/{task_id}/_cancel | E-01, E-02 (行番号71) | ○ |
| C-02 | nodesパラメータはlist型 | E-01, E-02 (行番号76) | ○ |
| C-03 | actionsパラメータはlist型 | E-01, E-02 (行番号78) | ○ |
| C-04 | parent_task_idパラメータはstring型 | E-01, E-02 (行番号79) | ○ |
| C-05 | wait_for_completionパラメータをサポート | E-01, E-02 (行番号87) | ○ |
| C-06 | group_byパラメータのデフォルトはnodes | E-02 (行番号80) | ○ |
| C-07 | listTasksResponseListenerを再利用 | E-02 (行番号90) | ○ |
| C-08 | CircuitBreakerをトリップしない | E-02 (行番号94-96) | ○ |
| C-09 | APIの安定性はexperimental | E-01 | ○ |
| C-10 | 関連機能は機能No.51（タスク管理） | E-05 | ○ |
| C-11 | CancelTasksRequestにsetTaskId, setNodes, setActions, setParentTaskIdを設定 | E-02 (行番号82-87) | ○ |
| C-12 | タスクのキャンセルは「協調的」である | E-01 | ○ |
| C-13 | CancelTasksResponseはListTasksResponseを継承 | E-02 (行番号90) | ○ |
| C-14 | キャンセル不可タスクの例外処理の具体的なHTTPステータス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- キャンセル不可タスクに対するキャンセル要求の具体的なエラーレスポンスはTransportCancelTasksActionの実装に依存
  - 候補：TransportCancelTasksAction.java / TaskManager.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義、パラメータ、ルーティングは全てソースコードで確認済み
- 0: 低リスク - listTasksResponseListenerの再利用はソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] キャンセル不可タスクに対するリクエストの実際のレスポンスを確認
- [ ] wait_for_completion=trueの場合の子孫タスクキャンセル完了待機動作を確認
