---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：115-リポジトリ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **リクエストボディの全フィールド一覧**：type, settings以外のフィールド確認が必要
  2. **同名リポジトリの上書き動作**：上書き動作の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create_repository.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPutRepositoryAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはPUT/POST /_snapshot/{repository} | E-01, E-02 (行番号63) | ○ |
| C-02 | repositoryパラメータはstring型で必須 | E-01 | ○ |
| C-03 | cluster_manager_timeoutパラメータをサポート | E-01, E-02 (行番号78-80) | ○ |
| C-04 | master_timeoutは非推奨（v2.0.0） | E-01 | ○ |
| C-05 | timeoutパラメータをサポート | E-01, E-02 (行番号82) | ○ |
| C-06 | verifyパラメータのデフォルトはtrue | E-02 (行番号77) | ○ |
| C-07 | リクエストボディは必須 | E-01 | ○ |
| C-08 | リクエストボディをXContentParserでパース | E-02 (行番号74-76) | ○ |
| C-09 | レスポンスにacknowledgedを含む | E-02 (行番号83) | ○ |
| C-10 | 関連機能は機能No.65（リポジトリ管理） | E-04 | ○ |
| C-11 | 画面No.115、カテゴリはスナップショット管理 | E-03 | ○ |
| C-12 | APIの安定性はstable | E-01 | ○ |
| C-13 | DeprecationLoggerによるmaster_timeout非推奨警告 | E-02 (行番号59, 81) | ○ |
| C-14 | リクエストボディのtype, settings, location, compressの詳細フィールド | **根拠なし** | △ |
| C-15 | 同名リポジトリの上書き動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リクエストボディの具体的なフィールド一覧はPutRepositoryRequest.source()の実装に依存
  - 候補：PutRepositoryRequest.java / RepositoryMetadata.java
- 同名リポジトリの上書き動作はRepositoriesService.registerRepositoryの実装に依存
  - 候補：RepositoriesService.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義、パラメータ、ルーティングは全てソースコードで確認済み
- 1: 中リスク - リクエストボディのフィールド一覧はリポジトリタイプにより異なる

## 6) レビュアーチェックリスト（最小）
- [ ] fsタイプリポジトリのsettingsフィールド一覧を確認
- [ ] s3タイプリポジトリのsettingsフィールド一覧を確認
- [ ] 同名リポジトリへの再登録時の動作を確認
