---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：120-スナップショット作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **リクエストボディの全フィールド一覧**：indices, ignore_unavailable等のフィールド確認が必要
  2. **wait_for_completion=trueのレスポンスフィールド詳細**：完了レスポンスの構造確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/snapshot.create.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestCreateSnapshotAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはPUT/POST /_snapshot/{repository}/{snapshot} | E-01, E-02 (行番号62-63) | ○ |
| C-02 | repositoryパラメータはstring型で必須 | E-01 | ○ |
| C-03 | snapshotパラメータはstring型で必須 | E-01 | ○ |
| C-04 | cluster_manager_timeoutパラメータをサポート | E-01, E-02 (行番号76-78) | ○ |
| C-05 | master_timeoutは非推奨（v2.0.0） | E-01 | ○ |
| C-06 | wait_for_completionパラメータのデフォルトはfalse | E-01, E-02 (行番号80) | ○ |
| C-07 | リクエストボディは任意 | E-01 | ○ |
| C-08 | リクエストボディをapplyContentParserでパース | E-02 (行番号75) | ○ |
| C-09 | createSnapshotRequestファクトリメソッドを使用 | E-02 (行番号74) | ○ |
| C-10 | DeprecationLoggerによるmaster_timeout非推奨警告 | E-02 (行番号58, 79) | ○ |
| C-11 | 関連機能は機能No.63（スナップショット作成・管理） | E-04 | ○ |
| C-12 | 画面No.120、カテゴリはスナップショット管理 | E-03 | ○ |
| C-13 | APIの安定性はstable | E-01 | ○ |
| C-14 | RestToXContentListenerでレスポンスを返す | E-02 (行番号81) | ○ |
| C-15 | リクエストボディのindices, ignore_unavailable, include_global_state, partialフィールド | **根拠なし** | △ |
| C-16 | wait_for_completion=trueの場合のレスポンスフィールド詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リクエストボディのフィールド一覧はCreateSnapshotRequest.source()の実装に依存
  - 候補：CreateSnapshotRequest.java
- wait_for_completion=trueの場合のレスポンスフィールドはCreateSnapshotResponseとSnapshotInfoに依存
  - 候補：CreateSnapshotResponse.java / SnapshotInfo.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API定義、パラメータ、ルーティングは全てソースコードで確認済み
- 1: 中リスク - リクエストボディのフィールドとレスポンスの詳細構造は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CreateSnapshotRequest.source()で受け付ける全フィールドを確認
- [ ] wait_for_completion=trueの場合のCreateSnapshotResponseの構造を確認
- [ ] 同名スナップショットが存在する場合のエラーメッセージを確認
- [ ] インクリメンタルスナップショットの動作仕様を確認
