---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：129-Danglingインデックスインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **accept_data_loss=false時の具体的なエラーメッセージ**：エラーメッセージの正確な文言

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/dangling_indices.import_dangling_index.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/dangling/RestImportDanglingIndexAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/dangling/import_index/TransportImportDanglingIndexAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（129行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（165行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは POST /_dangling/{index_uuid} | E-01, E-02 | ○ |
| C-02 | index_uuidは必須パスパラメータ | E-01, E-02 | ○ |
| C-03 | accept_data_lossパラメータが存在する | E-01, E-02 | ○ |
| C-04 | timeoutパラメータが存在する | E-01, E-02 | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01, E-02 | ○ |
| C-06 | master_timeoutはバージョン2.0.0で非推奨 | E-01 | ○ |
| C-07 | レスポンスはAcknowledgedResponse | E-02, E-03 | ○ |
| C-08 | HTTPステータスは202 Accepted | E-02（86行目、ACCEPTED定数） | ○ |
| C-09 | TransportImportDanglingIndexActionはHandledTransportActionを継承 | E-03（68行目） | ○ |
| C-10 | FindDanglingIndexActionでUUIDを全ノードから検索 | E-03（39-42行目import文） | ○ |
| C-11 | LocalAllocateDangledIndicesでクラスタに割り当て | E-03（49行目、71行目） | ○ |
| C-12 | 最大バージョンのメタデータを選択 | E-03（55行目Comparator） | ○ |
| C-13 | accept_data_loss=falseのデフォルト値 | E-02（73行目） | ○ |
| C-14 | 画面Noは129でDanglingインデックス管理カテゴリ | E-04 | ○ |
| C-15 | 主機能は機能No.1「インデックス作成」 | E-05 | ○ |
| C-16 | NodeClientを使用してFindDanglingIndexActionを呼び出す | E-03（72行目） | ○ |
| C-17 | accept_data_loss=false時の具体的なエラーメッセージ文言 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: エラーメッセージの正確な文言はTransportImportDanglingIndexAction内のバリデーションロジックに依存
  - 候補：TransportImportDanglingIndexAction.java のdoExecute()メソッド完全解析

## 5) リスクフラグ（レビュー観点）
- 0: APIエンドポイント・パラメータ定義（API specと完全一致）
- 0: 処理フロー（ソースコード確認済み）
- 0: HTTPステータス202（ソースコード確認済み）
- 1: エラーメッセージの文言（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] API仕様がREST API specと一致しているか
- [ ] accept_data_lossの動作が正しく記載されているか
- [ ] HTTPステータス202 Acceptedが正しいか
- [ ] FindDanglingIndexAction + LocalAllocateDangledIndicesの処理フローが正しいか
