---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 17
  claims_with_evidence: 15
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：13-クエリによる削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：15 / 17、根拠なし：2
- 優先レビュー（高）
  1. **HTTPステータス409の正確性**：根拠不足
  2. **非同期実行時のタスクIDレスポンス形式**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_by_query.json`
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestDeleteByQueryAction.java`
- E-03: `modules/reindex/src/main/java/org/opensearch/index/reindex/AbstractBulkByQueryRestHandler.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /{index}/_delete_by_queryのルート定義 | E-01, E-02 (行57) | ○ |
| C-02 | indexパスパラメータがlist型 | E-01 (parts.index.type: "list") | ○ |
| C-03 | conflicts, max_docsの特別なConsumer処理 | E-02 (行79-81) | ○ |
| C-04 | doPrepareRequest(request, client, false, false)の呼び出し | E-02 (行67) | ○ |
| C-05 | AbstractBulkByQueryRestHandlerのparseInternalRequest使用 | E-02 (行83), E-03 (行61) | ○ |
| C-06 | SearchRequestの内部構築とscroll_size設定 | E-03 (行82) | ○ |
| C-07 | conflictsパラメータの処理 | E-03 (行84-87) | ○ |
| C-08 | search_timeoutの設定 | E-03 (行90-92) | ○ |
| C-09 | requests_per_secondのデフォルト値0 | E-01 | ○ |
| C-10 | slicesのデフォルト値1、auto対応 | E-01 | ○ |
| C-11 | scroll_sizeのデフォルト値100 | E-01 | ○ |
| C-12 | wait_for_completionのデフォルト値true | E-01 | ○ |
| C-13 | timeoutのデフォルト値1m | E-01 | ○ |
| C-14 | 関連機能No.16（Delete By Query）とNo.19（全文検索） | E-05 | ○ |
| C-15 | リクエストボディが必須 | E-01 (body.required: true) | ○ |
| C-16 | コンフリクト時のHTTPステータス409 | **根拠なし** | △ |
| C-17 | 非同期実行時のタスクIDレスポンス形式の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- コンフリクト時のHTTPステータスコードはBulkByScrollResponseのレスポンスハンドリングに依存
  - 候補：BulkByScrollResponse.java / RestStatusToXContentListener
- 非同期実行時のタスクIDレスポンスはAbstractBaseReindexRestHandlerの実装に依存
  - 候補：AbstractBaseReindexRestHandler.java / TaskResultPersistenceService

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIルートとパラメータ定義は正確
- 1: 中リスク - エラーレスポンスの詳細は追加確認が必要
- 0: 低リスク - コードリーディングガイドの参照は正確

## 6) レビュアーチェックリスト（最小）
- [ ] C-16: コンフリクト時の正確なHTTPステータスコードを確認
- [ ] C-17: 非同期実行時のレスポンス形式を実際のAPIレスポンスと照合
- [ ] パラメータ一覧がdelete_by_query.jsonの全パラメータを網羅しているか確認
