---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：131-パイプライン取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **権限名の正確性**：権限文字列の正確な値は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.get_pipeline.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/ingest/RestGetPipelineAction.java`
- E-03: `server/src/main/java/org/opensearch/action/ingest/GetPipelineAction.java`
- E-04: `server/src/main/java/org/opensearch/ingest/IngestService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは `GET /_ingest/pipeline` と `GET /_ingest/pipeline/{id}` | E-01, E-02 (行61) | ○ |
| C-02 | idパラメータはカンマ区切りで複数指定可能、ワイルドカード対応 | E-01 (description: "Comma separated list of pipeline ids. Wildcards supported") | ○ |
| C-03 | cluster_manager_timeoutパラメータが存在する | E-01, E-02 (行72) | ○ |
| C-04 | master_timeoutはバージョン2.0.0で非推奨 | E-01 (deprecated.version: "2.0.0") | ○ |
| C-05 | RestGetPipelineActionがBaseRestHandlerを継承 | E-02 (行55) | ○ |
| C-06 | prepareRequestでStrings.splitStringByCommaToArrayを使用 | E-02 (行71) | ○ |
| C-07 | client.admin().cluster().getPipeline()を呼び出す | E-02 (行74) | ○ |
| C-08 | RestStatusToXContentListenerでレスポンス変換 | E-02 (行74) | ○ |
| C-09 | 画面No.131、画面名「パイプライン取得」 | E-05 (行132) | ○ |
| C-10 | 主機能は機能No.36「インジェストパイプライン」 | E-06 (行167) | ○ |
| C-11 | パイプラインが存在しない場合は404エラー | E-04 (ResourceNotFoundException) | ○ |
| C-12 | APIの安定性は "stable" | E-01 (stability: "stable") | ○ |
| C-13 | パイプライン定義にはdescription, processors, version, on_failureが含まれる | E-04 | ○ |
| C-14 | レスポンスはパイプラインIDをキーとしたオブジェクト形式 | E-04 | ○ |
| C-15 | 権限名は cluster:admin/ingest/pipeline/get | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: 権限名の正確な文字列はソースコード上で明示的に確認できなかった
  - 候補：OpenSearchセキュリティプラグインのドキュメント / ActionModule.java内の権限定義 / セキュリティ設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様はREST API specファイルとJavaソースコードから確認済み
- 1: 中リスク - 権限名の正確性については要確認

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス定義がREST API specと一致しているか
- [ ] パラメータの型とデフォルト値が正確か
- [ ] レスポンス構造の記述が実際のレスポンスと一致するか
- [ ] 権限名が実環境と一致するか
