---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：132-パイプライン作成・更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **権限名の正確性**：権限文字列の正確な値は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/ingest.put_pipeline.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/ingest/RestPutPipelineAction.java`
- E-03: `server/src/main/java/org/opensearch/action/ingest/PutPipelineAction.java`
- E-04: `server/src/main/java/org/opensearch/ingest/IngestService.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは `PUT /_ingest/pipeline/{id}` | E-01, E-02 (行62) | ○ |
| C-02 | リクエストボディは必須 | E-01 (body.required: true) | ○ |
| C-03 | cluster_manager_timeout, timeout パラメータが存在 | E-01, E-02 (行74,76) | ○ |
| C-04 | master_timeoutはバージョン2.0.0で非推奨 | E-01 (deprecated.version: "2.0.0") | ○ |
| C-05 | RestPutPipelineActionがBaseRestHandlerを継承 | E-02 (行56) | ○ |
| C-06 | contentOrSourceParamでボディを取得 | E-02 (行72) | ○ |
| C-07 | PutPipelineRequest(id, source, mediaType)で構築 | E-02 (行73) | ○ |
| C-08 | client.admin().cluster().putPipeline()を呼び出す | E-02 (行77) | ○ |
| C-09 | RestToXContentListenerでレスポンス変換 | E-02 (行77) | ○ |
| C-10 | 画面No.132、画面名「パイプライン作成・更新」 | E-05 (行133) | ○ |
| C-11 | 主機能は機能No.36「インジェストパイプライン」 | E-06 (行168) | ○ |
| C-12 | 同一IDの場合は上書き更新される | E-04 | ○ |
| C-13 | レスポンスにacknowledgedフィールドを含む | E-04 | ○ |
| C-14 | バリデーションエラー時は400が返却される | E-04 | ○ |
| C-15 | APIの安定性は "stable" | E-01 (stability: "stable") | ○ |
| C-16 | 権限名は cluster:admin/ingest/pipeline/put | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: 権限名の正確な文字列はソースコード上で明示的に確認できなかった
  - 候補：OpenSearchセキュリティプラグインのドキュメント / セキュリティ設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様はREST API specファイルとJavaソースコードから確認済み
- 1: 中リスク - 権限名の正確性については要確認

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス定義がREST API specと一致しているか
- [ ] リクエストボディの必須項目が正しいか
- [ ] タイムアウトパラメータのデフォルト値が正確か
- [ ] 権限名が実環境と一致するか
