---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：137-検索パイプライン作成・更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **リクエストボディの詳細フィールド**：phase_results_processorsの存在は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/search_pipeline.put.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestPutSearchPipelineAction.java`
- E-03: `server/src/main/java/org/opensearch/search/pipeline/SearchPipelineService.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは `PUT /_search/pipeline/{id}` | E-01, E-02 (行38) | ○ |
| C-02 | リクエストボディは必須 | E-01 (body.required: true) | ○ |
| C-03 | cluster_manager_timeout, timeout パラメータが存在 | E-01, E-02 (行45-46) | ○ |
| C-04 | master_timeoutパラメータは存在しない | E-01 (params内にmaster_timeoutなし) | ○ |
| C-05 | RestPutSearchPipelineActionがBaseRestHandlerを継承 | E-02 (行30) | ○ |
| C-06 | contentOrSourceParamでボディを取得 | E-02 (行43) | ○ |
| C-07 | PutSearchPipelineRequest(id, source, mediaType)で構築 | E-02 (行44) | ○ |
| C-08 | client.admin().cluster().putSearchPipeline()を呼び出す | E-02 (行47) | ○ |
| C-09 | RestToXContentListenerでレスポンス変換 | E-02 (行47) | ○ |
| C-10 | 画面No.137、画面名「検索パイプライン作成・更新」 | E-04 (行138) | ○ |
| C-11 | 主機能は機能No.45「検索パイプライン管理」 | E-05 (行174) | ○ |
| C-12 | APIの安定性は "stable" | E-01 (stability: "stable") | ○ |
| C-13 | 同一IDの場合は上書き更新 | E-03 | ○ |
| C-14 | リクエストボディにphase_results_processorsフィールドが含まれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: phase_results_processorsフィールドの存在はSearchPipelineServiceの詳細確認が必要
  - 候補：SearchPipelineService.java / PutSearchPipelineRequest.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様の基本部分は確認済み
- 1: 中リスク - リクエストボディの詳細フィールドは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] APIパスが正確か
- [ ] リクエストボディの各フィールドが正確か
- [ ] master_timeoutが確かに存在しないか
