---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：139-スクリプト取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目はなし。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/get_script.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetStoredScriptAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportGetStoredScriptAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは `GET /_scripts/{id}` | E-01, E-02 (行58) | ○ |
| C-02 | idパラメータは必須 | E-01 (parts.id) | ○ |
| C-03 | cluster_manager_timeoutパラメータが存在 | E-01, E-02 (行70) | ○ |
| C-04 | master_timeoutはバージョン2.0.0で非推奨 | E-01 (deprecated.version: "2.0.0") | ○ |
| C-05 | RestGetStoredScriptActionがBaseRestHandlerを継承 | E-02 (行52) | ○ |
| C-06 | GetStoredScriptRequest(id)で構築 | E-02 (行69) | ○ |
| C-07 | client.admin().cluster().getStoredScript()を呼び出す | E-02 (行72) | ○ |
| C-08 | RestStatusToXContentListenerでレスポンス変換 | E-02 (行72) | ○ |
| C-09 | TransportGetStoredScriptActionがTransportClusterManagerNodeReadActionを継承 | E-03 (行56) | ○ |
| C-10 | executor()はThreadPool.Names.SAMEを返す | E-03 (行84) | ○ |
| C-11 | ScriptService.getStoredScript()を使用してスクリプト取得 | E-03 (行98) | ○ |
| C-12 | ClusterBlockLevel.METADATA_READでブロックチェック | E-03 (行103) | ○ |
| C-13 | 画面No.139、画面名「スクリプト取得」 | E-04 (行140) | ○ |
| C-14 | 主機能は機能No.82「ストアドスクリプト」 | E-05 (行176) | ○ |
| C-15 | APIの安定性は "stable" | E-01 (stability: "stable") | ○ |
| C-16 | レスポンスに_id、found、scriptフィールドが含まれる | E-03 (GetStoredScriptResponse生成) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] APIパスが正確か
- [ ] レスポンスのフィールド構造が正確か
- [ ] 非推奨パラメータの説明が正確か
