---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：140-スクリプト作成・更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **コンパイル検証の詳細動作**：コンテキスト指定時のコンパイル検証の詳細は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/put_script.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPutStoredScriptAction.java`
- E-03: `server/src/main/java/org/opensearch/script/StoredScriptSource.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは4パターン（PUT/POST x コンテキスト有無） | E-01, E-02 (行63-69) | ○ |
| C-02 | idパスパラメータは必須 | E-01 (parts.id) | ○ |
| C-03 | contextパスパラメータは省略可能 | E-01 (2つのパスパターン) | ○ |
| C-04 | リクエストボディは必須 | E-01 (body.required: true) | ○ |
| C-05 | timeout, cluster_manager_timeout パラメータが存在 | E-01, E-02 (行87-89) | ○ |
| C-06 | master_timeoutはバージョン2.0.0で非推奨 | E-01 (deprecated.version: "2.0.0") | ○ |
| C-07 | contextクエリパラメータが存在 | E-01 (params.context) | ○ |
| C-08 | RestPutStoredScriptActionがBaseRestHandlerを継承 | E-02 (行57) | ○ |
| C-09 | パスパラメータからid、contextを取得 | E-02 (行80-81) | ○ |
| C-10 | requiredContent()でボディを取得 | E-02 (行82) | ○ |
| C-11 | StoredScriptSource.parse()でスクリプトソースをパース | E-02 (行84) | ○ |
| C-12 | PutStoredScriptRequest(id, context, content, mediaType, source)で構築 | E-02 (行86) | ○ |
| C-13 | client.admin().cluster().putStoredScript()を呼び出す | E-02 (行90) | ○ |
| C-14 | RestToXContentListenerでレスポンス変換 | E-02 (行90) | ○ |
| C-15 | 画面No.140、画面名「スクリプト作成・更新」 | E-04 (行141) | ○ |
| C-16 | 主機能は機能No.82「ストアドスクリプト」 | E-05 (行177) | ○ |
| C-17 | APIの安定性は "stable" | E-01 (stability: "stable") | ○ |
| C-18 | コンテキスト指定時にコンパイル検証が行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: コンテキスト指定時のコンパイル検証の詳細はScriptService.javaのputStoredScript()メソッドの完全な読み解きが必要
  - 候補：ScriptService.java内のputStoredScript()メソッド / TransportPutStoredScriptAction.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様はREST API specとJavaソースコードから確認済み
- 1: 中リスク - コンパイル検証の詳細動作は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 4つのURLパスが正しく記述されているか
- [ ] リクエストボディの必須フィールドが正しいか
- [ ] コンテキスト指定時の動作が正確か
- [ ] 非推奨パラメータの説明が正確か
