---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：141-スクリプト削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ResourceNotFoundExceptionの404レスポンス**：ScriptServiceの内部実装未確認
  2. **デフォルトタイムアウト30s**：AcknowledgedRequestのデフォルト値確認が必要
  3. **セキュリティ上のリスク記述**：一般論であり根拠コードなし

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/delete_script.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestDeleteStoredScriptAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/DeleteStoredScriptRequest.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportDeleteStoredScriptAction.java`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはDELETE /_scripts/{id}である | E-01, E-02（行58） | ○ |
| C-02 | idパスパラメータは必須のstring型である | E-01 | ○ |
| C-03 | timeoutパラメータはtime型でオプション | E-01 | ○ |
| C-04 | cluster_manager_timeoutパラメータが利用可能 | E-01, E-02（行71-73） | ○ |
| C-05 | master_timeoutはv2.0.0で非推奨 | E-01 | ○ |
| C-06 | IDが空の場合にバリデーションエラー | E-03（行74） | ○ |
| C-07 | IDに#が含まれる場合にバリデーションエラー | E-03（行76） | ○ |
| C-08 | クラスタマネージャノードで処理が実行される | E-04（TransportClusterManagerNodeAction継承） | ○ |
| C-09 | ScriptServiceのdeleteStoredScriptが呼ばれる | E-04（行104） | ○ |
| C-10 | METADATA_WRITEレベルのブロックチェック | E-04（行108-110） | ○ |
| C-11 | ClusterManagerTaskThrottlerによるスロットリング | E-04（行85） | ○ |
| C-12 | AcknowledgedResponseが返却される | E-04（行60, 94-96） | ○ |
| C-13 | 関連機能はストアドスクリプト(No.82) | E-05 | ○ |
| C-14 | API安定性はstable | E-01 | ○ |
| C-15 | 存在しないスクリプト指定時に404エラー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: ScriptService.deleteStoredScriptの内部実装を確認していないため、存在しないスクリプトIDの場合の正確なエラーレスポンスが不明
  - 候補：ScriptService.java / ScriptMetadata.java / 実際のAPIテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様はREST API specとソースコードから直接確認済み
- 1: 中リスク - ResourceNotFoundExceptionの正確なレスポンス形式は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptService.deleteStoredScriptの実装を確認し、存在しないスクリプトID指定時の挙動を検証する
- [ ] AcknowledgedRequestのデフォルトタイムアウト値（30s）を確認する
- [ ] 実際のAPIテストで非推奨パラメータの警告メッセージを確認する
