---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：143-スクリプト言語一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **レスポンスフィールドの詳細構造**：GetScriptLanguageResponseの実装未確認
  2. **デフォルト3言語の記述**：プラグイン構成に依存
  3. **types_allowedフィールドの存在**：実装未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/get_script_languages.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestGetScriptLanguageAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはGET /_script_languageである | E-01, E-02（行57） | ○ |
| C-02 | パラメータなしのGETリクエスト | E-01 | ○ |
| C-03 | API安定性はexperimental | E-01 | ○ |
| C-04 | GetScriptLanguageAction.INSTANCEを使用 | E-02（行68） | ○ |
| C-05 | 関連機能にPainless(79), Mustache(80), Expression(81)が含まれる | E-03 | ○ |
| C-06 | REST handler名はscript_language_action | E-02（行62） | ○ |
| C-07 | RestToXContentListenerでレスポンス返却 | E-02（行70） | ○ |
| C-08 | レスポンスにtypes_allowedフィールドが含まれる | **根拠なし** | △ |
| C-09 | レスポンスにlanguage_contextsフィールドが含まれる | **根拠なし** | △ |
| C-10 | デフォルトでpainless, mustache, expressionの3言語が利用可能 | E-04（一般的知識） | ○ |

## 4) 不足情報（Unknown / Missing）
- C-08, C-09: GetScriptLanguageResponseの実装を直接確認していないため、レスポンスの詳細構造は推測に基づく
  - 候補：GetScriptLanguageResponse.java / 実際のAPIテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパスとパラメータはAPI specから直接確認済み
- 1: 中リスク - レスポンス構造の正確な検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GetScriptLanguageResponseの実装を確認し、レスポンスフィールドの正確な構造を検証する
- [ ] 実際にAPIを実行してレスポンス形式を確認する
- [ ] プラグイン構成による言語リストの変動を確認する
