---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：147-Cat アロケーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全主張について根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.allocation.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestAllocationAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはGET /_cat/allocationおよびGET /_cat/allocation/{node_id} | E-01, E-02（行72） | ○ |
| C-02 | node_idパスパラメータはlist型でオプション | E-01 | ○ |
| C-03 | bytesパラメータはenum型で複数単位をサポート | E-01 | ○ |
| C-04 | master_timeoutはv2.0.0で非推奨 | E-01 | ○ |
| C-05 | テーブルカラムにshards, disk.indices, disk.used, disk.avail, disk.total, disk.percent, host, ip, nodeが含まれる | E-02（行122-131） | ○ |
| C-06 | デフォルトでdata:trueのノードが対象 | E-02（行87） | ○ |
| C-07 | 2段階リクエスト（ClusterState→NodesStats） | E-02（行96, 106） | ○ |
| C-08 | ルーティングテーブルから全シャードを走査 | E-02（行138） | ○ |
| C-09 | ノードごとのシャード数をInteger::sumで集計 | E-02（行145） | ○ |
| C-10 | ディスク使用率の計算式 used * 100 / (used + avail) | E-02（行163） | ○ |
| C-11 | UNASSIGNEDシャード行の追加 | E-02（行180-193） | ○ |
| C-12 | FS統計とストア情報を取得 | E-02（行101-103） | ○ |
| C-13 | handler名はcat_allocation_action | E-02（行77） | ○ |
| C-14 | 関連機能はシャードアロケーション(No.56) | E-03 | ○ |
| C-15 | ClusterStateRequest.clear().routingTable(true) | E-02（行89） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がAPI specとソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ディスク使用率計算のエッジケース（0除算等）を確認する
- [ ] UNASSIGNEDシャード行の表示形式を実際のAPIで確認する
