---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：148-Cat クラスタマネージャ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全主張について根拠あり。重点レビュー不要。

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.cluster_manager.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestClusterManagerAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスはGET /_cat/cluster_managerおよび非推奨 /_cat/master | E-01, E-02（行63） | ○ |
| C-02 | /_cat/masterはv2.0.0で非推奨 | E-01 | ○ |
| C-03 | ReplacedRouteを使用 | E-02（行63） | ○ |
| C-04 | テーブルカラムにid, host, ip, nodeが含まれる | E-02（行103-107） | ○ |
| C-05 | ClusterStateRequest.clear().nodes(true) | E-02（行78-79） | ○ |
| C-06 | localパラメータをサポート | E-02（行80） | ○ |
| C-07 | cluster_manager_timeoutをサポート | E-02（行81-83） | ○ |
| C-08 | canTripCircuitBreakerがfalse | E-02（行95-97） | ○ |
| C-09 | クラスタマネージャnull時に全カラム`-`表示 | E-02（行117-121） | ○ |
| C-10 | クラスタマネージャ存在時にgetId/getHostName/getHostAddress/getName | E-02（行123-126） | ○ |
| C-11 | handler名はcat_cluster_manager_action | E-02（行68） | ○ |
| C-12 | 関連機能はクラスタマネージャ選出(No.53) | E-03 | ○ |
| C-13 | master_timeoutの非推奨パラメータ対応 | E-01, E-02（行84） | ○ |
| C-14 | 1行のみのテーブルを返す | E-02（行115-128） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がAPI specとソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨パス使用時の警告メッセージの内容を確認する
