---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：15-クエリによる更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **コンフリクト時のHTTPステータス409の正確性**：根拠不足
  2. **スクリプト未指定時のnoop更新動作の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/update_by_query.json`
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestUpdateByQueryAction.java`
- E-03: `modules/reindex/src/main/java/org/opensearch/index/reindex/AbstractBulkByQueryRestHandler.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /{index}/_update_by_queryのルート定義 | E-01, E-02 (行57-58) | ○ |
| C-02 | doPrepareRequest(request, client, false, true)の呼び出し | E-02 (行67-68) | ○ |
| C-03 | conflicts, script, max_docsのConsumer設定 | E-02 (行80-83) | ○ |
| C-04 | Script.parse(o)によるスクリプトパース | E-02 (行82) | ○ |
| C-05 | pipeline パラメータの設定（setPipeline） | E-02 (行87) | ○ |
| C-06 | pipelineクエリパラメータのサポート | E-01 (params.pipeline) | ○ |
| C-07 | bodyが任意（required未設定） | E-01 (bodyにrequired未設定) | ○ |
| C-08 | version_typeパラメータの存在 | E-01 (params.version_type) | ○ |
| C-09 | Delete By Queryとの共通パラメータ | E-01, E-03 | ○ |
| C-10 | scroll_sizeのデフォルト値100 | E-01 | ○ |
| C-11 | requests_per_secondのデフォルト値0 | E-01 | ○ |
| C-12 | AbstractBulkByQueryRestHandlerの継承 | E-02 (行50) | ○ |
| C-13 | 関連機能No.15とNo.19 | E-05 | ○ |
| C-14 | UpdateByQueryAction.INSTANCEの使用 | E-02 (行52) | ○ |
| C-15 | コンフリクト時のHTTPステータス409 | **根拠なし** | △ |
| C-16 | スクリプト未指定時のnoop更新動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- コンフリクト時のHTTPステータスコードはBulkByScrollResponseのレスポンスハンドリングに依存
  - 候補：BulkByScrollResponse.java / AbstractBaseReindexRestHandler.java
- スクリプト未指定時の動作はTransportUpdateByQueryActionの内部実装に依存
  - 候補：TransportUpdateByQueryAction.java / BulkByScrollTask.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - REST API定義とハンドラの整合性は高い
- 1: 中リスク - noop更新の動作詳細は追加確認が必要
- 0: 低リスク - Delete By Queryとの差分（script, pipeline）は正確に記載

## 6) レビュアーチェックリスト（最小）
- [ ] C-15: コンフリクト時の正確なHTTPステータスコードを確認
- [ ] C-16: スクリプト未指定時の実際の動作を確認
- [ ] pipelineパラメータの動作（body指定 vs クエリパラメータ指定）を確認
