---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：161-Cat シャード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティプラグインの権限制御詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.shards.json` - REST APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestShardsAction.java` - RESTハンドラ実装（行86-604）
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/shards/CatShardsRequest.java` - リクエストオブジェクト
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行162）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行200）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは /_cat/shards と /_cat/shards/{index} | E-01, E-02 行91-93 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01 | ○ |
| C-03 | パラメータにformat, bytes, local, cluster_manager_timeout, h, help, s, time, vが存在 | E-01 | ○ |
| C-04 | master_timeoutはOpenSearch 2.0.0で非推奨 | E-01 | ○ |
| C-05 | デフォルト表示カラムはindex, shard, prirep, state, docs, store, ip, node | E-02 行152-160 | ○ |
| C-06 | prirep列はp=プライマリ, r=レプリカ, s=検索専用 | E-02 行394-402 | ○ |
| C-07 | 80以上のカラムが定義されている | E-02 行149-358 | ○ |
| C-08 | AbstractListActionを継承している | E-02 行86 | ○ |
| C-09 | isActionPaginated()はfalseを返す | E-02 行601-603 | ○ |
| C-10 | allowSystemIndexAccessByDefaultがtrue | E-02 行101-103 | ○ |
| C-11 | isRequestLimitCheckSupportedがtrue | E-02 行112-114 | ○ |
| C-12 | CatShardsActionを通じてクラスタ状態とインデックス統計を取得 | E-02 行127, E-03 | ○ |
| C-13 | 再配置中シャードはnode列に移動先情報を表示 | E-02 行411-421 | ○ |
| C-14 | 未割り当てシャードの理由・時刻・詳細を表示 | E-02 行433-444 | ○ |
| C-15 | 読み取り専用でデータベース更新なし | E-02 (GETメソッドのみ) | ○ |
| C-16 | 関連機能No.56 シャードアロケーション | E-05 行200 | ○ |
| C-17 | cancel_after_time_intervalでタイムアウト可能 | E-02 行122, E-03 行81-87 | ○ |
| C-18 | セキュリティプラグインによるインデックス単位の権限制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインの権限制御の詳細仕様はセキュリティプラグインのソースコードに依存しており、本プロジェクトのコアソースからは確認できない
  - 候補：security plugin ソースコード / OpenSearchドキュメント / セキュリティ設計書

## 5) リスクフラグ（レビュー観点）
- 0: テーブルカラム定義の網羅性（80+カラムの一部のみ記載）
- 0: ページネーション無効状態の記載は正確

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト表示カラム（8列）が正確か確認
- [ ] prirep列の3種類（p/r/s）の条件分岐が正確か確認
- [ ] 未割り当てシャード情報の表示仕様を確認
