---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：163-Cat タスク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **generateListTasksRequestの詳細パラメータ解析ロジック**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.tasks.json` - REST APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestTasksAction.java` - RESTハンドラ実装（行70-204）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行164）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行202）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは /_cat/tasks のみ | E-01, E-02 行79 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01 | ○ |
| C-03 | パラメータにformat, nodes, actions, detailed, parent_task_id, h, help, s, time, vが存在 | E-01 | ○ |
| C-04 | 標準カラムは15個（id, action, task_id, parent_task_id, type, start_time, timestamp, running_time_ns, running_time, node_id, ip, port, node, version, x_opaque_id） | E-02 行122-147 | ○ |
| C-05 | detailed=trueでdescriptionとresource_statsカラムが追加 | E-02 行143-146 | ○ |
| C-06 | タスクはTaskGroupとして階層化される | E-02 行187-195 | ○ |
| C-07 | 開始時刻の昇順でソートされる | E-02 行190 | ○ |
| C-08 | 再帰的にchildTasksを展開する | E-02 行193 | ○ |
| C-09 | 親タスクIDなしの場合は"-"を表示 | E-02 行161-165 | ○ |
| C-10 | ノード離脱時はIP/ポート/ノード名に"-"を表示 | E-02 行174-177 | ○ |
| C-11 | X-Opaque-ID未設定時は"-"を表示 | E-02 行178 | ○ |
| C-12 | 時刻表示はUTCのHH:mm:ss形式 | E-02 行151 | ○ |
| C-13 | nodesInCluster SupplierでDiscoveryNodesをリアルタイム取得 | E-02 行71, 188 | ○ |
| C-14 | 読み取り専用でデータベース更新なし | E-02 (GETメソッドのみ) | ○ |
| C-15 | 関連機能No.51 タスク管理 | E-04 行202 | ○ |
| C-16 | generateListTasksRequestの詳細パラメータ解析 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `generateListTasksRequest`メソッドの詳細実装は`RestListTasksAction`にあるが、本調査ではそのファイルの内容を直接確認していない
  - 候補：RestListTasksAction.java / ListTasksRequest.java

## 5) リスクフラグ（レビュー観点）
- 0: カラム定義はソースコードと一致
- 0: TaskGroup階層化・ソートロジックはソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 15標準カラムの定義が正確か確認
- [ ] detailed追加カラム（description, resource_stats）が正確か確認
- [ ] generateListTasksRequestのフィルタリングパラメータ（nodes, actions, parent_task_id）の処理を確認
