---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：164-Cat テンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特段の優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.templates.json` - REST APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` - RESTハンドラ実装（行60-141）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行165）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行203）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは /_cat/templates と /_cat/templates/{name} | E-01, E-02 行65-67 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01 | ○ |
| C-03 | パラメータにformat, local, cluster_manager_timeout, h, help, s, vが存在 | E-01 | ○ |
| C-04 | 表示カラムは5個（name, index_patterns, order, version, composed_of） | E-02 行100-108 | ○ |
| C-05 | ClusterStateRequestでmetadata=trueを指定 | E-02 行82-83 | ○ |
| C-06 | レガシーテンプレートはmetadata.templates()から取得 | E-02 行114 | ○ |
| C-07 | Composableテンプレートはmetadata.templatesV2()から取得 | E-02 行126 | ○ |
| C-08 | nameパラメータはRegex.simpleMatch()でフィルタリング | E-02 行115, 129 | ○ |
| C-09 | レガシーテンプレートのcomposed_of列は空文字列 | E-02 行121 | ○ |
| C-10 | Composableテンプレートのcomposed_of列にコンポーネント一覧 | E-02 行135 | ○ |
| C-11 | レガシーテンプレートはorder、Composableはpriorityがorder列に表示 | E-02 行119, 133 | ○ |
| C-12 | master_timeoutはOpenSearch 2.0.0で非推奨 | E-01 | ○ |
| C-13 | 読み取り専用でデータベース更新なし | E-02 (GETメソッドのみ) | ○ |
| C-14 | 関連機能No.7 インデックステンプレート | E-04 行203 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に根拠があり、不足情報はなし。

## 5) リスクフラグ（レビュー観点）
- 0: 全主張がソースコードにより検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 5カラムの定義が正確か確認
- [ ] レガシーとComposableの表示差異が正確か確認
