---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：165-Cat スレッドプール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **sizeパラメータ非推奨の正確なバージョン**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.thread_pool.json` - REST APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestThreadPoolAction.java` - RESTハンドラ実装（行75-336）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行166）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行204）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは /_cat/thread_pool と /_cat/thread_pool/{thread_pool_patterns} | E-01, E-02 行80-82 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01 | ○ |
| C-03 | パラメータにformat, local, cluster_manager_timeout, h, help, s, vが存在 | E-01 | ○ |
| C-04 | 表示カラムは22個 | E-02 行149-177 | ○ |
| C-05 | デフォルト表示はnode_name, name, active, queue, rejected | E-02 行150, 157, 159, 161, 163 | ○ |
| C-06 | 3段階ネストコールバック（ClusterState -> NodesInfo -> NodesStats） | E-02 行96-131 | ○ |
| C-07 | fork_joinタイプは専用の表示ロジック | E-02 行193, 204-219 | ○ |
| C-08 | fork_joinではactive/pool_size/queue等は0、parallelismにmax値 | E-02 行207-219 | ○ |
| C-09 | fixedタイプはsize列、scalingタイプはcore/max列に値 | E-02 行234-242 | ○ |
| C-10 | スレッドプール名はTreeMapでソート | E-02 行298 | ○ |
| C-11 | Regex.simpleMatchでパターンフィルタ | E-02 行281 | ○ |
| C-12 | thread_pool_patternsのデフォルトは"*" | E-02 行266 | ○ |
| C-13 | master_timeoutはOpenSearch 2.0.0で非推奨 | E-01 | ○ |
| C-14 | 読み取り専用でデータベース更新なし | E-02 (GETメソッドのみ) | ○ |
| C-15 | 関連機能No.128 スレッドプール管理 | E-04 行204 | ○ |
| C-16 | NodesInfoRequestでPROCESSとTHREAD_POOLメトリクスを要求 | E-02 行110-111 | ○ |
| C-17 | sizeパラメータはOpenSearch 7.7.0で非推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- sizeパラメータの非推奨バージョン7.7.0はAPIスペック（E-01）に記載されているが、これはElasticsearch時代のバージョンであり、OpenSearchにおける正確な非推奨バージョンは異なる可能性がある
  - 候補：OpenSearch変更履歴 / CHANGELOG.md

## 5) リスクフラグ（レビュー観点）
- 0: カラム定義はソースコードと一致
- 0: 3段階ネストコールバック構造はソースコードと一致
- 1: sizeパラメータの非推奨バージョンはOpenSearchでの正確な値を確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] 22カラムの定義が正確か確認
- [ ] fork_joinタイプの特別処理が正確か確認
- [ ] sizeパラメータの非推奨バージョンを確認
