---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：166-Cat PITセグメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **無効PIT ID指定時のエラー挙動詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestPitSegmentsAction.java` - RESTハンドラ実装（行39-155）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行167）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行205-206）
- E-04: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segments.json` - 関連APIスペック

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは /_cat/pit_segments/_all と /_cat/pit_segments | E-01 行48-49 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01 行49 | ○ |
| C-03 | 表示カラムは15個 | E-01 行99-116 | ○ |
| C-04 | _allパスの場合は全PIT対象 | E-01 行64-67 | ○ |
| C-05 | それ以外はリクエストボディからPIT IDをパース | E-01 行69-78 | ○ |
| C-06 | PitSegmentsActionを実行 | E-01 行80 | ○ |
| C-07 | 4階層ループ（IndexSegments > IndexShardSegments > ShardSegments > Segment） | E-01 行124-152 | ○ |
| C-08 | size.memoryカラムは常に0L | E-01 行142 | ○ |
| C-09 | prirep列はprimary()がtrueなら"p"、それ以外は"r" | E-01 行134 | ○ |
| C-10 | allowSystemIndexAccessByDefaultがtrue | E-01 行58-60 | ○ |
| C-11 | リクエストボディパース失敗時にIllegalArgumentException | E-01 行76-77 | ○ |
| C-12 | nodesInCluster SupplierでDiscoveryNodesをリアルタイム取得 | E-01 行40-41, 122 | ○ |
| C-13 | 関連機能No.23 PIT、No.121 セグメント情報 | E-03 行205-206 | ○ |
| C-14 | 無効PIT ID指定時のエラー挙動 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 無効なPIT IDを指定した場合のエラーレスポンスの詳細は、PitSegmentsAction内部のバリデーションロジックに依存する
  - 候補：TransportPitSegmentsAction.java / PIT関連テスト

## 5) リスクフラグ（レビュー観点）
- 0: カラム定義はソースコードと一致
- 1: size.memoryが常に0Lの理由は推測であり、正式な理由は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 15カラムの定義が正確か確認
- [ ] _allパスと通常パスの分岐ロジックを確認
- [ ] size.memoryが常に0Lである理由を確認
