---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：167-WLM統計一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **breachパラメータの詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/wlm_stats_list.json` - REST APIスペック定義
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestWlmStatsAction.java` - RESTハンドラ実装（行52-256）
- E-03: `server/src/main/java/org/opensearch/action/pagination/WlmPaginationStrategy.java` - ページネーション戦略実装（行32-273）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（行168）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（行207-208）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル形式パスは /_list/wlm_stats系、JSON形式は /_wlm/stats系 | E-02 行59-72, 91-96 | ○ |
| C-02 | HTTPメソッドはGETのみ | E-01, E-02 行59-72 | ○ |
| C-03 | パラメータにsize, next_token, sort, order, vが存在 | E-01, E-02 行86-89, 108 | ○ |
| C-04 | デフォルトページサイズは10 | E-02 行54 | ○ |
| C-05 | 最大ページサイズは100 | E-02 行55 | ○ |
| C-06 | sizeが0以下または100超でOpenSearchParseException | E-02 行148-149 | ○ |
| C-07 | sortのデフォルトはnode_id | E-02 行88 | ○ |
| C-08 | orderのデフォルトはasc | E-02 行89 | ○ |
| C-09 | 表示カラムは7個（NODE_ID, WORKLOAD_GROUP_ID, TOTAL_COMPLETIONS, TOTAL_REJECTIONS, TOTAL_CANCELLATIONS, CPU_USAGE, MEMORY_USAGE） | E-02 行185-198 | ○ |
| C-10 | カラム間は"|"区切り | E-02 行186, 188, 190, 192, 194, 196 | ○ |
| C-11 | WlmPaginationStrategyでワークロードグループ単位に展開 | E-03 行112-123 | ○ |
| C-12 | SHA-256ハッシュでページネーション整合性を検証 | E-03 行63-74, 76-78 | ○ |
| C-13 | トークンは暗号化される | E-03 行218-228 | ○ |
| C-14 | 最終ページで"No more pages available"フッター行を追加 | E-02 行252-253, 226-233 | ○ |
| C-15 | CPU/メモリ統計不可時は"NA"を表示 | E-02 行220-221 | ○ |
| C-16 | 無効next_token時にユーザー向けエラーメッセージ | E-02 行162-163, 154-180 | ○ |
| C-17 | 本APIはexperimental（実験的）ステータス | E-01 行3, E-02 行51 | ○ |
| C-18 | 関連機能No.101 ワークロードグループ管理、No.102 ワークロード管理プラグイン | E-05 行207-208 | ○ |
| C-19 | sortに無効値でOpenSearchParseException | E-02 行130-135 | ○ |
| C-20 | breachパラメータの動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- `breach`パラメータはRestWlmStatsAction行83でパースされているが、`request.param("boolean")`と記載されておりパラメータ名が`breach`ではなく`boolean`になっている（潜在的バグの可能性）。また、このパラメータの下流での使用方法はWlmStatsRequest内部に依存する
  - 候補：WlmStatsRequest.java / WLMプラグインソースコード

## 5) リスクフラグ（レビュー観点）
- 2: breachパラメータのパース処理に `request.param("boolean")` と記載されており、本来 `request.param("breach")` であるべき可能性が高い（ソースコード行83のバグ疑い）
- 0: ページネーション関連ロジックはソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 7カラムの定義が正確か確認
- [ ] ページネーショントークンの生成・検証ロジックを確認
- [ ] breachパラメータのパース処理（行83）のバグ疑いを確認
- [ ] "No more pages available"フッター行の動作を確認
