---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：17-Reindex

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リモートReindex時のConnectTransportException詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/reindex.json`
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestReindexAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /_reindexのルート定義 | E-01, E-02 (行62) | ○ |
| C-02 | pipelineクエリパラメータの禁止 | E-02 (行77-80) | ○ |
| C-03 | ReindexRequest.fromXContent()によるボディパース | E-02 (行84-86) | ○ |
| C-04 | scrollパラメータの処理 | E-02 (行88-90) | ○ |
| C-05 | require_aliasパラメータの処理 | E-02 (行91-93) | ○ |
| C-06 | FILTERED_FIELDSによるパスワードフィルタリング | E-02 (行98-103) | ○ |
| C-07 | RestRequestFilterインターフェースの実装 | E-02 (行54) | ○ |
| C-08 | doPrepareRequest(request, client, true, true)の呼び出し | E-02 (行72) | ○ |
| C-09 | scrollのデフォルト値5m | E-01 (scroll.default: "5m") | ○ |
| C-10 | timeoutのデフォルト値1m | E-01 (timeout.default: "1m") | ○ |
| C-11 | requests_per_secondのデフォルト値0 | E-01 | ○ |
| C-12 | slicesのデフォルト値1 | E-01 | ○ |
| C-13 | bodyが必須 | E-01 (body.required: true) | ○ |
| C-14 | 関連機能No.14とNo.19 | E-04 | ○ |
| C-15 | pipelineエラーメッセージの正確な内容 | E-02 (行78-79) | ○ |
| C-16 | AbstractBaseReindexRestHandlerの継承 | E-02 (行54) | ○ |
| C-17 | ReindexAction.INSTANCEの使用 | E-02 (行57) | ○ |
| C-18 | リモートReindex時のConnectTransportException | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リモートReindex時の接続エラーの詳細はRemoteScrollableHitSourceの実装に依存
  - 候補：RemoteScrollableHitSource.java / TransportReindexAction.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RESTハンドラのソースコードとの整合性は非常に高い
- 1: 中リスク - リモートReindex関連の記述は追加確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] C-18: リモートReindex時の接続エラーの正確な例外タイプを確認
- [ ] リクエストボディの全フィールドが実際のfromXContent()パーサーと一致しているか確認
- [ ] dest.version_type, dest.op_typeの指定可能値を確認
