---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：18-Reindexスロットル変更

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **ResourceNotFoundException発生時のレスポンス詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/reindex_rethrottle.json`
- E-02: `modules/reindex/src/main/java/org/opensearch/index/reindex/RestRethrottleAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /_reindex/{task_id}/_rethrottleルート | E-01, E-02 (行62) | ○ |
| C-02 | task_idパスパラメータが必須 | E-01 | ○ |
| C-03 | requests_per_secondが必須パラメータ | E-01, E-02 (行77-79) | ○ |
| C-04 | 3つのRethrottle APIが同一クラスで処理 | E-02 (行58-63) | ○ |
| C-05 | IllegalArgumentException（requests_per_second未指定時） | E-02 (行77-79) | ○ |
| C-06 | RethrottleAction.INSTANCEの実行 | E-02 (行83) | ○ |
| C-07 | 関連機能No.14とNo.51 | E-04 | ○ |
| C-08 | rest-api-specとソースコードのパラメータ名の差異 | E-01, E-02 | ○ |
| C-09 | group_byパラメータのデフォルトがnodes | E-02 (行81) | ○ |
| C-10 | ResourceNotFoundException発生時のレスポンス詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- タスクIDが存在しない場合のエラーレスポンス形式はTransportRethrottleActionの実装に依存
  - 候補：TransportRethrottleAction.java / TaskManager.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - No.14, No.16と同一の実装基盤であり、信頼性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] C-10: 存在しないタスクIDを指定した場合のエラーレスポンスを確認
- [ ] No.14, No.16との記述の一貫性を確認
