---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Security権限制御の詳細**: ソースコード上にSecurity Pluginの直接参照なし
  2. **CircuitBreakingExceptionのHTTPステータス429**: 間接的な推定
  3. **Stream Search機能の詳細仕様**: フィーチャーフラグ制御のため変更の可能性あり

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/search.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestSearchAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /_search, GET/POST /{index}/_search | E-01, E-02(行122-131) | ○ |
| C-02 | qパラメータでLuceneクエリ文字列構文をサポート | E-01(params.q) | ○ |
| C-03 | デフォルトサイズ10、デフォルトfrom 0 | E-01(params.size, params.from) | ○ |
| C-04 | search_typeにquery_and_fetch/dfs_query_and_fetchは禁止 | E-02(行227-228) | ○ |
| C-05 | terminate_afterが負の値でIllegalArgumentException | E-02(行294-295) | ○ |
| C-06 | rest_total_hits_as_intのバリデーション | E-02(行423-443) | ○ |
| C-07 | PITとindices/routing/preference/ccs_minimize_roundtripsの併用不可 | E-02(行381-396) | ○ |
| C-08 | Stream Search機能のフィーチャーフラグ分岐 | E-02(行153-166) | ○ |
| C-09 | batched_reduce_sizeのデフォルト512 | E-01(params.batched_reduce_size) | ○ |
| C-10 | max_concurrent_shard_requestsのデフォルト5 | E-01(params.max_concurrent_shard_requests) | ○ |
| C-11 | suggest_field/suggest_mode/suggest_size/suggest_textパラメータ | E-01, E-02(行364-375) | ○ |
| C-12 | search_pipelineパラメータ | E-01(params.search_pipeline), E-02(行243) | ○ |
| C-13 | include_named_queries_scoreパラメータ | E-01, E-02(行98, 246) | ○ |
| C-14 | cancel_after_time_intervalパラメータ | E-02(行256) | ○ |
| C-15 | 関連機能マッピング（機能No.20, 19, 31, 32, 25, 29, 45） | E-04 | ○ |
| C-16 | 画面遷移（スクロール、PIT、検索テンプレートとの連携） | E-05 | ○ |
| C-17 | レスポンス構造（took, timed_out, _shards, hits） | E-01(documentation) | ○ |
| C-18 | Security権限制御（403エラー） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: Security Pluginはプラグインとして別モジュールで提供されるため、本体ソースコードには直接的な参照がない
  - 候補：Security Plugin ソースコード / OpenSearch公式ドキュメント / Security Plugin REST API仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIルート、パラメータ仕様はREST API仕様と完全一致
- 0: 低リスク - エラーメッセージはソースコードから直接抽出
- 1: 中リスク - Stream Search機能はフィーチャーフラグ制御のため、今後のバージョンで変更の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] REST API仕様（search.json）のパラメータ一覧が設計書と一致しているか
- [ ] RestSearchAction.javaの行番号参照が現在のコードと一致しているか
- [ ] Security関連の権限制御記述が実際の挙動と一致しているか
- [ ] レスポンスフィールドの記述が最新のAPI仕様と整合しているか
