---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-複数検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/msearch.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestMultiSearchAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /_msearch, GET/POST /{index}/_msearch | E-01, E-02(行94-101) | ○ |
| C-02 | NDJSON形式のリクエストボディ（bulk serialize） | E-01(body.serialize: "bulk") | ○ |
| C-03 | リクエストボディは必須 | E-01(body.required: true) | ○ |
| C-04 | max_concurrent_searchesパラメータ | E-01, E-02(行129-131) | ○ |
| C-05 | max_concurrent_shard_requestsのデフォルト5 | E-01(params.max_concurrent_shard_requests.default: 5) | ○ |
| C-06 | cancel_after_time_intervalの優先順位（個別 > マルチ） | E-02(行170-173) | ○ |
| C-07 | allowExplicitIndex設定 | E-02(行87-89) | ○ |
| C-08 | pre_filter_shard_sizeの伝播 | E-02(行133-136, 163-165) | ○ |
| C-09 | ccs_minimize_roundtripsのデフォルトtrue | E-01(params.ccs_minimize_roundtrips.default) | ○ |
| C-10 | rest_total_hits_as_intのデフォルトfalse | E-01(params.rest_total_hits_as_int.default: false) | ○ |
| C-11 | 関連機能マッピング（機能No.21, 20） | E-04 | ○ |
| C-12 | supportsContentStream() = true | E-02(行212-214) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードまたはAPI仕様に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] NDJSON形式のリクエストボディ例が正しいか
- [ ] RestMultiSearchAction.javaの行番号が現在のコードと一致しているか
