---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-検索説明

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/explain.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestExplainAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /{index}/_explain/{id} | E-01, E-02(行62) | ○ |
| C-02 | indexとidは必須パスパラメータ | E-01(parts), E-02(行72) | ○ |
| C-03 | fieldsパラメータは廃止、stored_fieldsを使用 | E-02(行86-89) | ○ |
| C-04 | parentパラメータの明示的サポート | E-02(行73) | ○ |
| C-05 | qパラメータとリクエストボディの両方に対応（ボディ優先） | E-02(行77-84) | ○ |
| C-06 | FetchSourceContextによる_source制御 | E-02(行99), E-01(params._source等) | ○ |
| C-07 | dfのデフォルト値は_all | E-01(params.df.description) | ○ |
| C-08 | routingはstring型（listではない） | E-01(params.routing.type: "string") | ○ |
| C-09 | クエリパラメータ一覧の正確性 | E-01(params) | ○ |
| C-10 | 関連機能マッピング（機能No.27） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンパクトな実装で全体の確認が容易

## 6) レビュアーチェックリスト（最小）
- [ ] RestExplainAction.javaの行番号が現在のコードと一致しているか
- [ ] レスポンスのexplanation構造の記述が実際のLucene Explanation出力と一致しているか
