---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-フィールド機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/field_caps.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/RestFieldCapabilitiesAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /_field_caps, GET/POST /{index}/_field_caps | E-01, E-02(行58-67) | ○ |
| C-02 | fieldsパラメータでフィールド名をカンマ区切りで指定 | E-01(params.fields), E-02(行77-78) | ○ |
| C-03 | include_unmappedのデフォルトfalse | E-01(params.include_unmapped.default: false), E-02(行82) | ○ |
| C-04 | index_filterをリクエストボディで指定可能 | E-01(body), E-02(行83-87) | ○ |
| C-05 | expand_wildcardsのデフォルトopen | E-01(params.expand_wildcards.default: "open") | ○ |
| C-06 | IndicesOptionsの設定 | E-02(行81) | ○ |
| C-07 | client.fieldCaps()でアクション実行 | E-02(行88) | ○ |
| C-08 | クエリパラメータ一覧の正確性 | E-01(params) | ○ |
| C-09 | 関連機能マッピング（機能No.26） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードまたはAPI仕様に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] RestFieldCapabilitiesAction.javaの行番号が現在のコードと一致しているか
- [ ] レスポンスのフィールド構造がOpenSearchの現行バージョンと一致しているか
