---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-複数検索テンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/msearch_template.json`
- E-02: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/RestMultiSearchTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /_msearch/template, GET/POST /{index}/_msearch/template | E-01, E-02(行72-80) | ○ |
| C-02 | NDJSON形式のリクエストボディ（bulk serialize） | E-01(body.serialize: "bulk") | ○ |
| C-03 | リクエストボディは必須 | E-01(body.required: true) | ○ |
| C-04 | max_concurrent_searchesパラメータ | E-01, E-02(行99-100) | ○ |
| C-05 | scriptがnullの場合「Malformed search template」エラー | E-02(行109, 118) | ○ |
| C-06 | RestMultiSearchAction.parseMultiLineRequestの再利用 | E-02(行103-106) | ○ |
| C-07 | RestSearchAction.checkRestTotalHitsの呼び出し | E-02(行120) | ○ |
| C-08 | search_pipelineの個別設定 | E-02(行111-114) | ○ |
| C-09 | allowExplicitIndex設定 | E-02(行66-68) | ○ |
| C-10 | 関連機能マッピング（機能No.21, 80） | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードまたはAPI仕様に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] RestMultiSearchTemplateAction.javaの行番号が現在のコードと一致しているか
- [ ] NDJSON形式のリクエストボディ例が正しいか
