---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：29-ランク評価

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **サポートされる評価メトリクスの詳細一覧**: モジュール内実装クラスの網羅的確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/rank_eval.json`
- E-02: `modules/rank-eval/src/main/java/org/opensearch/index/rankeval/RestRankEvalAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIルート: GET/POST /_rank_eval, GET/POST /{index}/_rank_eval | E-01, E-02(行109-117) | ○ |
| C-02 | リクエストボディは必須 | E-01(body.required: true) | ○ |
| C-03 | stability: experimental | E-01(stability: "experimental") | ○ |
| C-04 | search_typeの選択肢（query_then_fetch/dfs_query_then_fetch） | E-01(params.search_type.options) | ○ |
| C-05 | executeLocallyで実行 | E-02(行126) | ○ |
| C-06 | RankEvalSpec.parseで評価仕様を解析 | E-02(行139) | ○ |
| C-07 | IndicesOptions設定 | E-02(行135) | ○ |
| C-08 | searchType設定 | E-02(行136-138) | ○ |
| C-09 | 関連機能マッピング（機能No.111, 20） | E-04 | ○ |
| C-10 | サポートされる評価メトリクス（precision, recall, dcg等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-10: 評価メトリクスの完全な一覧はRankEvalSpec内のパーサーおよびEvaluationMetricの実装クラスを確認する必要がある
  - 候補：modules/rank-eval配下のメトリクス実装クラス / OpenSearch公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - experimental APIのため将来のバージョンで変更の可能性あり
- 0: 低リスク - APIルートとパラメータはAPI仕様から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされる評価メトリクスの一覧が最新版と一致しているか
- [ ] experimentalステータスが現行バージョンでも維持されているか
- [ ] RestRankEvalAction.javaの行番号が現在のコードと一致しているか
