---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-クエリバリデーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **権限制御の詳細**：Security Plugin連携の具体的な挙動は未確認
  2. **HTTPステータス403の発生条件**：権限不足時の具体的なレスポンスコード

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.validate_query.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestValidateQueryAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/validate/query/ValidateQueryRequest.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/validate/query/ValidateQueryResponse.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET/POSTメソッドで4つのエンドポイントパスが存在する | E-01, E-02 | ○ |
| C-02 | explainパラメータでエラー詳細が取得できる | E-01, E-02 | ○ |
| C-03 | rewriteパラメータでLuceneクエリ書き換え結果を確認可能 | E-01, E-02 | ○ |
| C-04 | all_shardsパラメータで全シャード検証が可能 | E-01, E-02 | ○ |
| C-05 | qパラメータでLuceneクエリ文字列を指定可能 | E-01, E-02 | ○ |
| C-06 | analyzerパラメータでアナライザ指定可能 | E-01 | ○ |
| C-07 | default_operatorのデフォルトはOR | E-01 | ○ |
| C-08 | expand_wildcardsのデフォルトはopen | E-01 | ○ |
| C-09 | リクエストボディでQuery DSLを指定可能 | E-01, E-02 | ○ |
| C-10 | ParsingException時はvalid=falseでHTTP 200を返す | E-02 | ○ |
| C-11 | データベース更新は発生しない（読み取り専用） | E-02 | ○ |
| C-12 | レスポンスにvalidフィールドが含まれる | E-02, E-04 | ○ |
| C-13 | 関連機能はNo.28 Validate API | E-06 | ○ |
| C-14 | 検索API（No.21）との連携で使用される | E-07 | ○ |
| C-15 | BroadcastRequestパターンで各シャードに分散される | E-03 | ○ |
| C-16 | RestValidateQueryActionの行番号参照（行83-116等） | E-02 | ○ |
| C-17 | Security Plugin有効時にインデックスレベル権限制御が適用される | **根拠なし** | △ |
| C-18 | 権限不足時にHTTP 403が返される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Security Pluginとの連携挙動についてはプラグインのソースコードを参照する必要がある
  - 候補：`plugins/security/` / OpenSearch Security Plugin外部リポジトリ / Security関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: API仕様（パラメータ・エンドポイント）はREST API仕様ファイルとソースコードで十分に裏付けられている
- 1: 権限制御に関する記述はSecurity Plugin依存であり、コアソースのみでは検証不完全

## 6) レビュアーチェックリスト（最小）
- [ ] API仕様のパラメータ一覧がREST API specと一致しているか
- [ ] レスポンスフィールドが実際のValidateQueryResponseと一致しているか
- [ ] 権限制御に関する記述が実環境と一致しているか
- [ ] コードリーディングガイドの行番号が最新ソースと一致しているか
