---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：32-スクロール検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **SearchContextMissingExceptionのHTTPステータス**：実際のステータスコードの確認が必要
  2. **スクロールコンテキストの自動削除タイミング**：具体的な実装の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/scroll.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestSearchScrollAction.java`
- E-03: `server/src/main/java/org/opensearch/action/search/TransportSearchScrollAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET/POSTで4つのエンドポイントパスが存在する | E-01, E-02 | ○ |
| C-02 | scroll_idパスパラメータは非推奨（7.0.0） | E-01 | ○ |
| C-03 | scrollパラメータでコンテキスト維持時間を指定 | E-01, E-02 | ○ |
| C-04 | rest_total_hits_as_intパラメータのデフォルトはfalse | E-01 | ○ |
| C-05 | ボディの値がパラメータより優先される | E-02 | ○ |
| C-06 | SearchScrollRequest.fromXContent()でボディをパースする | E-02 | ○ |
| C-07 | Scrollオブジェクトで時間を管理する | E-02 | ○ |
| C-08 | client.searchScroll()でTransport層に委譲 | E-02 | ○ |
| C-09 | レスポンスに_scroll_id, took, hits等が含まれる | E-02 | ○ |
| C-10 | 関連機能はNo.22 スクロール検索 | E-05 | ○ |
| C-11 | 検索API(No.21)から遷移、スクロールクリア(No.33)に遷移 | E-06 | ○ |
| C-12 | データ変更は発生しない | E-02 | ○ |
| C-13 | RestSearchScrollActionの行番号参照が正確 | E-02 | ○ |
| C-14 | RESPONSE_PARAMSにTOTAL_HITS_AS_INT_PARAMが含まれる | E-02 | ○ |
| C-15 | SearchContextMissingExceptionで404が返される | **根拠なし** | △ |
| C-16 | スクロールコンテキストが時間経過で自動削除される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SearchContextMissingExceptionの実際のHTTPステータスコードはTransport層の例外ハンドリングを確認する必要がある
  - 候補：TransportSearchScrollAction / SearchService / RestController例外マッピング

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント仕様・パラメータはREST API specとソースコードで裏付けられている
- 1: 例外時のHTTPステータスコードは推定値であり要確認

## 6) レビュアーチェックリスト（最小）
- [ ] scroll_idパスパラメータの非推奨バージョンが正しいか
- [ ] レスポンスフィールドが実際のSearchResponseと一致しているか
- [ ] 例外発生時のHTTPステータスコードが正確か
- [ ] コードリーディングガイドの行番号が最新ソースと一致しているか
