---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：34-PIT作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスのcreation_timeフィールド**：CreatePitResponseの正確なフィールド定義を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/create_pit.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/search/RestCreatePitAction.java`
- E-03: `server/src/main/java/org/opensearch/action/search/TransportCreatePitAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POSTメソッドで1つのエンドポイントが存在する | E-01, E-02 | ○ |
| C-02 | allow_partial_pit_creationのデフォルトはtrue | E-02 | ○ |
| C-03 | keep_aliveパラメータでPIT存続時間を指定 | E-01, E-02 | ○ |
| C-04 | preferenceパラメータでノード/シャード指定可能 | E-01, E-02 | ○ |
| C-05 | routingパラメータでルーティング指定可能 | E-01, E-02 | ○ |
| C-06 | リクエストボディは不要 | E-01 | ○ |
| C-07 | IndicesOptions.fromRequest()でインデックスオプション設定 | E-02 | ○ |
| C-08 | client.createPit()でTransport層に委譲 | E-02 | ○ |
| C-09 | 関連機能はNo.23 Point in Time（PIT） | E-05 | ○ |
| C-10 | 検索API(No.21)でPIT付き検索を実行 | E-06 | ○ |
| C-11 | PIT削除(No.35)でリソース解放 | E-06 | ○ |
| C-12 | RestCreatePitActionの行番号参照が正確 | E-02 | ○ |
| C-13 | CreatePitRequestにkeepAlive, allowPartialPitCreation, indicesがある | E-02 | ○ |
| C-14 | indexパスパラメータは必須 | E-01 | ○ |
| C-15 | レスポンスにcreation_timeフィールドが含まれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CreatePitResponseの正確なフィールド定義はCreatePitResponse.javaを確認する必要がある
  - 候補：CreatePitResponse.java / CreatePitResponseTests.java

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント仕様・パラメータはREST API specとソースコードで十分に裏付けられている
- 1: レスポンスフィールドのcreation_timeの存在は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] CreatePitResponseのフィールドが正確か（特にcreation_time）
- [ ] keep_alive未指定時のエラーハンドリングの確認
- [ ] コードリーディングガイドの行番号が最新ソースと一致しているか
