---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：38-インデックス作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **タイムアウトのデフォルト値**：timeout/cluster_manager_timeoutのデフォルト値
  2. **ResourceAlreadyExistsExceptionのHTTPステータス**：実際のステータスコード

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.create.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestCreateIndexAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/create/TransportCreateIndexAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PUTメソッドで/{index}エンドポイント | E-01, E-02 | ○ |
| C-02 | wait_for_active_shardsパラメータが存在する | E-01, E-02 | ○ |
| C-03 | timeoutパラメータが存在する | E-01, E-02 | ○ |
| C-04 | master_timeoutが2.0.0で非推奨 | E-01 | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01, E-02 | ○ |
| C-06 | ボディでsettings/mappings/aliasesを指定可能 | E-01, E-02 | ○ |
| C-07 | XContentHelper.convertToMap()でボディ変換 | E-02 | ○ |
| C-08 | prepareMappings()でマッピング正規化 | E-02 | ○ |
| C-09 | type定義のネストが許可されない | E-02 | ○ |
| C-10 | MapperService.isMappingSourceTyped()でチェック | E-02 | ○ |
| C-11 | ActiveShardCount.parseString()でwait_for設定 | E-02 | ○ |
| C-12 | client.admin().indices().create()でTransport層に委譲 | E-02 | ○ |
| C-13 | 関連機能No.1, 17, 18, 7 | E-05 | ○ |
| C-14 | 画面遷移（ドキュメント登録、クローン、縮小等） | E-06 | ○ |
| C-15 | レスポンスにacknowledged, shards_acknowledged, index | E-02 | ○ |
| C-16 | RestCreateIndexActionの行番号参照が正確 | E-02 | ○ |
| C-17 | DeprecationLoggerでmaster_timeout非推奨警告 | E-02 | ○ |
| C-18 | インデックス名の命名規則制限 | E-02 | ○ |
| C-19 | タイムアウトのデフォルト値が30s | **根拠なし** | △ |
| C-20 | ResourceAlreadyExistsExceptionのHTTPステータスが400 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- タイムアウトのデフォルト値はCreateIndexRequest内のデフォルト値を確認する必要がある
  - 候補：CreateIndexRequest.java / AcknowledgedRequest.java
- ResourceAlreadyExistsExceptionのHTTPステータスマッピングはRestController等を確認する必要がある

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント仕様・パラメータ・マッピング正規化はソースコードで裏付けられている
- 1: タイムアウトデフォルト値と一部例外のHTTPステータスは推定含む

## 6) レビュアーチェックリスト（最小）
- [ ] タイムアウトのデフォルト値が正確か
- [ ] ResourceAlreadyExistsExceptionのHTTPステータスが正確か
- [ ] prepareMappings()のtype定義チェックロジックが正確か
- [ ] 関連機能マッピングが画面機能マッピング.csvと一致しているか
- [ ] コードリーディングガイドの行番号が最新ソースと一致しているか
